#------------------------------------------------------------
# Kreuzungsampel_CLUSB4.py                  Victor Klein 1.1.07
# Test der Kreuzungsampel mit beiden Ampeln
# keine Verwendung von Threads, kann aus der IDLE gestartet werden
#-----------------------------------------------------------
from CompulabUSB4 import *
from time import *

class kreuzung(object):

    def __init__(self):
        self.outwert = 0
        self.test = 1
        self.cl0 = CompulabUSB4()        # Interfaceobjekt 0 schaffen
        self.cl0.INIT(0)                 # und mit 0-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0
        
    def berechne(self):
        wert = 0
        for i in self.bitliste:
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        if self.test:
            print self.bitliste,"bitaus", self.outwert
        self.cl0.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        if self.test:
            print self.bitliste,"bitaus", self.outwert
        self.cl0.DOUT(self.outwert)
        
        
    def betrieb(self):
        self.bitan(0)   #  A1 rot
        self.bitan(3)   #  A2 rot
        for i in range(2):
            wartezeit = 0.3
            self.bitan(0)   # a1 rot
            self.bitan(3)
            sleep(wartezeit*5)
            self.bitan(1)   # a1 rotgelb
            sleep(wartezeit*2)
            self.bitaus(0)
            self.bitaus(1)
            self.bitan(2)   # a1 gruen
            sleep(wartezeit*8)
            self.bitaus(2)
            self.bitan(1)   # a1 gelb
            sleep(wartezeit*2)
            self.bitaus(1)
            self.bitan(0)   # a1 rot Wechselpause
            sleep(wartezeit*5)
            self.bitan(4)  # a2 rotgelb
            sleep(wartezeit*2)
            self.bitaus(3)
            self.bitaus(4)
            self.bitan(5)  # a2 gruen
            sleep(wartezeit*8)
            self.bitaus(5)
            self.bitan(4)   # a2 gelb
            sleep(wartezeit*2)
            self.bitaus(4)
            self.bitan(3)
            
        
# Ausfuehren-------------------------

k = kreuzung()
k.betrieb()
        
