# ---------------------------------------------------------------------------------------
#
# CompulabUSB4.py            Victor Klein 1.1.07
#                           Python 2.4 getestet
# Modul CompulabUSB mit Funktionen zum Betrieb des CompulabUSB Interfaces
# Klasse CompulabUSB          : Kapselung und Erweiterung der Funktionen von CLUSB4.DLL
#                                bentigt CLUSB4.DLL
# Klasse CompulabUSBException : Raise CompulabUSB Ausnahmen
# 
# Ideen aus FishFa30.py   Ulrich Mueller 14.08.03
# ---------------------------------------------------------------------------------------

from ctypes import *

class CompulabUSBException(IOError):
  "Allgemeiner CompulabUSB Fehler"
  
  
class CompulabUSB4(object):

  ergebnis       = -1          # gleichzeitig Open-Merker (no Open = -1)                          
  nr = -1
  Fehler       = -1



  
  def __init__(self):
    self.ergebnis = -1
    self.nr = -1
    
  def INIT(self,nr):
    "Verbindung zum Interface Nr herstellen"
    if nr < 0:
       raise CompulabUSBException, "InterfaceProblem.INIT nr < 0"
    if nr >255:
       raise CompulabUSBException, "InterfaceProblem.INIT nr > 255" 
    self.nr = nr
    self.ergebnis = windll.CLUSB4.INIT(self.nr)
    if self.ergebnis == self.Fehler:
      raise CompulabUSBException, "InterfaceProblem.INIT"
    return self.ergebnis       
    
  def AIN(self, AnalogNr):
    "Einlesen Analogwert "
    if self.nr == -1:
       raise CompulabUSBException,"kein Compulab ausgewaehlt"
    return windll.CLUSB4.AIN(self.nr,AnalogNr)

  def DIN(self):
    "Einlesen Digitalwert "
    if self.nr == -1:
       raise CompulabUSBException,"kein Compulab ausgewaehlt"
    return windll.CLUSB4.DIN(self.nr)

  def DOUT(self, Wert):
    "Setzen Digitalausgang"
    if self.nr == -1:
       raise CompulabUSBException,"kein Compulab ausgewaehlt"
    windll.CLUSB4.DOUT(self.nr,Wert)
    return self.nr

  
  def Version(self):
    "Version der Klasse"
    return "1.1.07"

  
