'Radio SI4735, UKW , Potiabstimmung

$regfile = "attiny25.dat"

$crystal = 1000000

Dim F As Word
Dim Fr As Word
Dim H As Byte
Dim L As Byte
Dim T As Byte
Dim Poti As Integer
Dim Potialt As Integer
Dim Potidif As Integer
Dim Kanal As Byte
Dim Kanalalt As Byte
Dim R1 As Byte
Dim R2 As Byte
Dim R3 As Byte

Dim N As Byte
Dim Nmax As Byte
Dim Teilung As Word

Const F1 = 8880
Const F2 = 9510
Const F3 = 9650
Const F4 = 9920
Const F5 = 10670

Declare Sub Freq
Declare Sub Scan
Declare Sub Fm_tune_status()

  Config Adc = Single , Prescaler = Auto
  Start Adc
  Config Scl = Portb.3
  Config Sda = Portb.0
  I2cinit

  Portb.1 = 1                                               'Pullup am Taster

  Waitms 300
  I2cstart
  I2cwbyte 34
  I2cwbyte &H01
  I2cwbyte &H10                                             '00 FM, 01 AM, 10 32-kHz-Osz
  I2cwbyte &H05
  I2cstop
  Waitms 800


  If Pinb.1 = 0 Then                                        'Beim Start 1 s drcken: Programmiermodus
   Do
     Waitms 10
   Loop Until Pinb.1 = 1
   F = 8700
   Freq
   Waitms 200
   N = 0
    Do
      Scan                                                  'Neuen kanal suchen
      Do
        Waitms 10
      Loop Until Pinb.1 = 0
      T = 0
      Do
        Waitms 10
        T = T + 1                                           'Lnge des Tastenducks messen
        If T > 200 Then T = 200
      Loop Until Pinb.1 = 1
      If T > 100 Then                                       'lnger 1 s: Speichern
        Fm_tune_status
        Writeeeprom F , N
        'Print #1 , F , N
        N = N + 2
        F = &HFFFF                                          'Endemarke
        Writeeeprom F , N
      End If
    Loop
  End If                                                    'Ende Programmieren ber Taste


  N = 0                                                     'Anzahl der gespeicherten Kanle lesen
  Nmax = 0
  Do
    Readeeprom F , N
    If F < 10800 Then Nmax = Nmax + 1
    N = N + 2
  Loop Until F = &HFFFF

  If Nmax = 0 Then Scan
  N = Nmax * 2
  N = N - 1
  Teilung = 1024 / N
  Kanalalt = 255
  Do
    Poti = Getadc(2)                                        'Abstimmung ber Poti
    Poti = Poti / Teilung
    If Poti.0 = 0 Then                                      'Hyterese
       Kanal = Poti / 2
    End If
    If Kanal <> Kanalalt Then
      N = Kanal * 2
      Readeeprom F , N
      Freq
      Kanalalt = Kanal
    End If
    If Pinb.2 = 1 Then Goto Empf                            'Signal vom PC?
  Loop

Empf:
    Do
    Loop Until Pinb.2 = 0
    Waitms 100
    Open "comb.2:1200,8,n,1,INVERTED" For Input As #1
    Do
      Input #1 , Fr                                         'Eingabe 8880 fr Freq oder 1...20 fr Speicherplatz
      If Fr > 6499 Then                                     'Untergrenze 6500
        F = Fr
        Freq
      End If
      If Fr < 20 Then
         If F > 11000 Then F = &HFFFF
         N = Fr
         If N > 0 Then                                      'Speicherplatz 1...20 erlaubt
           N = N - 1
           N = N * 2
           Writeeeprom F , N
         End If
      End If
    Loop


Sub Freq
  I2cstart
  I2cwbyte 34
  I2cwbyte &H20
  I2cwbyte &H00
  H = High(f)
  L = Low(f)
  I2cwbyte H
  I2cwbyte L
  I2cwbyte &H00
  I2cstop
End Sub

Sub Scan
  I2cstart
  I2cwbyte 34
  I2cwbyte &H21
  I2cwbyte &H08
  I2cstop
End Sub

Sub Fm_tune_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H22
  I2cwbyte &H3
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte R1 , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R1 , Nack
  F = 256 * R2
  F = F + R3
  I2cstop
End Sub


End