'--------------------------------------------------------------
' eDIP240-7
' ATMEGA644P, 11,0592 MHz
' I2C-Display
' Edip3.bas
'--------------------------------------------------------------

$regfile = "m644Pdef.dat"
$crystal = 11059200
$hwstack = 64
$swstack = 64
$framesize = 64


Dim Dat As Byte
Dim Sbuf As Byte
Dim Rbuf As Byte
Dim Bcc As Byte
Dim Touchcode As Byte
Dim Endcode As Byte
Dim C As String * 1
Dim N As Integer
Dim Buffer As String * 24
Dim Time_repeat As Integer

Dim Count As Integer
Dim U As Integer


Declare Sub Write_edip
Declare Sub Read_edip
Declare Sub Read_edip_repeating
Declare Sub Buffer_edip


Portb = 255                                                 'Pullups

Config Sda = Portb.2
Config Scl = Portb.3

Const Slave = &HDC                                          'I2C write DC
Const Slaverd = &HDD                                        'I2C read DD

  I2cinit

  Config Adc = Single , Prescaler = 32 , Reference = Off    ' Pre 8...32
  Start Adc
  Config Timer1 = Pwm , Prescale = 8 , Pwm = 10 , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down
  Start Timer1


  Buffer = Chr(27) + "DL" + Chr(13)                         'clear
  Write_edip
  'Touch button at 10,10;60,30, Touchcode 121, Endcode = 250
  Buffer = Chr(27) + "AT" + Chr(10) + Chr(10) + Chr(60) + Chr(30) + Chr(121) + Chr(250) + "+" + Chr(13)
  Write_edip
  'Touch button at 70,10;120,30, Touchcode 122, Endcode = 250
  Buffer = Chr(27) + "AT" + Chr(70) + Chr(10) + Chr(120) + Chr(30) + Chr(122) + Chr(250) + "-" + Chr(13)
  Write_edip
  Buffer = Chr(27) + "ZF" + Chr(2) + Chr(13)                '2 = FONT6x8
  Write_edip


   Time_repeat = 200
Do
  If Touchcode = 0 Then Read_edip Else Read_edip_repeating
  If Touchcode = 121 Then                                   '+ Endwert
    If Time_repeat > 90 Then Count = Count + 1
    If Time_repeat < 91 Then Count = Count + 5
    If Time_repeat < 11 Then Count = Count + 10
    If Count > 1023 Then Count = 1023
  End If
  If Touchcode = 122 Then                                   '+ Endwert
    If Time_repeat > 90 Then Count = Count - 1
    If Time_repeat < 91 Then Count = Count - 5
    If Time_repeat < 11 Then Count = Count - 10
    If Count < 0 Then Count = 0
  End If

  If Touchcode > 100 Then Time_repeat = Time_repeat - 2
  If Time_repeat < 30 Then Time_repeat = 30
  If Touchcode = 0 Then Time_repeat = 200
  Waitms Time_repeat

  Pwm1a = Count
  Buffer = Chr(27) + "ZL" + Chr(10) + Chr(60) + "PWM1A = " + Str(count) + "  " + Chr(13)
  Write_edip
  U = Getadc(0)
  Buffer = Chr(27) + "ZL" + Chr(10) + Chr(80) + "ADC(0) = " + Str(u) + "  " + Chr(13)
  Write_edip


Loop


'***************************** eDIP240-7 ************************


Sub Write_edip
  I2cstart
  I2cwbyte Slave
  Dat = 17
  I2cwbyte Dat
  N = Len(buffer)
  Bcc = 17 + N
  I2cwbyte N
  For N = 1 To Len(buffer)
   C = Mid(buffer , N , 1)
   Dat = Asc(c)
   If Dat = 255 Then Dat = 1
   I2cwbyte Dat                                             'Asc(c)
   Bcc = Bcc + Asc(c)
  Next N
  I2cwbyte Bcc
  I2cstop
  Waitms 1
  N = 0
 'Delay                       'getestet: Ack abholen ist ntig ...
  I2cstart
  I2cwbyte Slaverd
  I2crbyte Dat , Nack
  I2cstop
  N = N + 1
  Waitms 1
End Sub


Sub Buffer_edip
  I2cstart
  I2cwbyte Slave
  Dat = 18                                                  'DC2
  I2cwbyte Dat
  N = 1                                                     '1 Byte
  Bcc = 18 + N
  I2cwbyte N
  'Waitms 1
  C = "I"
  Dat = Asc(c)
  Bcc = Bcc + Dat
  I2cwbyte Dat                                              '"I"
  I2cwbyte Bcc
  I2cstop
  Waitms 1

  I2cstart
  I2cwbyte Slaverd
  I2crbyte Dat , Ack                                        '06=ACK
  I2crbyte Dat , Ack                                        '18=DC2
  'Print Dat
  I2crbyte Dat , Ack                                        '2=2 Bytes
  I2crbyte Sbuf , Ack                                       'Send Buffer
  'Print Sbuf
  I2crbyte Rbuf , Ack                                       'Receive Buffer
  'Print Rbuf
  I2crbyte Dat , Nack                                       'BCC
  I2cstop
  Waitms 1
End Sub


Sub Read_edip
  Touchcode = 0
  Buffer_edip
  If Sbuf > 0 Then
    I2cstart
    I2cwbyte Slave
    Dat = 18                                                'DC2
    I2cwbyte Dat
    N = 1                                                   '1 Byte
    Bcc = 18 + N
    I2cwbyte N
    C = "S"
    Dat = Asc(c)
    Bcc = Bcc + Dat
    I2cwbyte Dat                                            '"I"
    I2cwbyte Bcc
    I2cstop
    I2cstart
    I2cwbyte Slaverd
    I2crbyte Dat , Ack                                      '06=ACK
    I2crbyte Dat , Ack                                      '17=DC1
    I2crbyte Dat , Ack                                      '4...
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    If Dat > 100 Then Touchcode = Dat                       'Touchcode > 100!!
    I2crbyte Dat , Nack                                     'BCC
    I2cstop
  End If
End Sub


Sub Read_edip_repeating
  ' last touchcode relaining
  Endcode = 0
  Buffer_edip
  If Sbuf > 0 Then
    I2cstart
    I2cwbyte Slave
    Dat = 18                                                'DC2
    I2cwbyte Dat
    N = 1                                                   '1 Byte
    Bcc = 18 + N
    I2cwbyte N
    C = "S"
    Dat = Asc(c)
    Bcc = Bcc + Dat
    I2cwbyte Dat                                            '"I"
    I2cwbyte Bcc
    I2cstop
    I2cstart
    I2cwbyte Slaverd
    I2crbyte Dat , Ack                                      '06=ACK
    I2crbyte Dat , Ack                                      '17=DC1
    I2crbyte Dat , Ack                                      '4...
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    I2crbyte Dat , Ack                                      'bufferdata
    If Dat > 100 Then Touchcode = Dat                       'Touchcode > 100
    If Dat > 200 Then Endcode = Dat                         'Tastencode > 200 = Endcode
    If Endcode > 200 Then Touchcode = 0
    I2crbyte Dat , Nack                                     'BCC
    I2cstop
  End If
End Sub

End




End