'--------------------------------------------------------------
' eDIP240-7
' ATMEGA644P, 11,0592 MHz
' I2C-Display
' edip1.bas
'--------------------------------------------------------------

$regfile = "m644Pdef.dat"
$crystal = 11059200
$hwstack = 64
$swstack = 64
$framesize = 64


Dim Dat As Byte
Dim Sbuf As Byte
Dim Rbuf As Byte
Dim Bcc As Byte
Dim Touchcode As Byte
Dim Endcode As Byte
Dim C As String * 1
Dim N As Integer
Dim Buffer As String * 24


Declare Sub Write_edip


Portb = 255                                                 'Pullups

Config Sda = Portb.2
Config Scl = Portb.3

Const Slave = &HDC                                          'I2C write DC
Const Slaverd = &HDD                                        'I2C read DD

I2cinit


  Buffer = Chr(27) + "YH" + Chr(80)                         '80% brightness
  Write_edip

  Buffer = Chr(27) + "DL" + Chr(13)                         'clear
  Write_edip

  Buffer = Chr(27) + "ZF" + Chr(2) + Chr(13)                '2 = FONT6x8
  Write_edip


  Buffer = Chr(27) + "ZL" + Chr(100) + Chr(60) + "eDIP240-7" + Chr(13)
  Write_edip


Do
Loop



'***************************** eDIP240-7 ************************


Sub Write_edip
  I2cstart
  I2cwbyte Slave
  Dat = 17
  I2cwbyte Dat
  N = Len(buffer)
  Bcc = 17 + N
  I2cwbyte N
  For N = 1 To Len(buffer)
   C = Mid(buffer , N , 1)
   Dat = Asc(c)
   If Dat = 255 Then Dat = 1
   I2cwbyte Dat                                             'Asc(c)
   Bcc = Bcc + Asc(c)
  Next N
  I2cwbyte Bcc
  I2cstop
  Waitms 1
  N = 0
 'Delay                       'getestet: Ack abholen ist ntig ...
  I2cstart
  I2cwbyte Slaverd
  I2crbyte Dat , Nack
  I2cstop
  N = N + 1
  Waitms 1
End Sub


End