/*
 Fade
 
 This example shows how to fade an LED on pin 9
 using the analogWrite() function.
 
 This example code is in the public domain.
 */

int led1 = 4;           // the pin that the LED is attached to
int led2 = 5;           // the pin that the LED is attached to
int brightness = 1;    // how bright the LED is
int fadeAmount = 1;    // how many points to fade the LED by


// the setup routine runs once when you press reset:
void setup()  { 
  pinMode(led1,OUTPUT);
  pinMode(led2,OUTPUT);
  }


// the loop routine runs over and over again forever:
void loop()  { 
  // set the brightness of pin 9:
  analogWrite(led1, brightness);    
  analogWrite(led2, 255-brightness);    

  // change the brightness for next time through the loop:
  brightness = brightness + fadeAmount;

  // reverse the direction of the fading at the ends of the fade: 
  if (brightness == 1 || brightness == 250) {
    fadeAmount = -fadeAmount ; 
  }     
  // wait for 30 milliseconds to see the dimming effect    
  delay(30);                            
}

