'--------------------------------------------------------------
' ESM32 SIOS
' ATMEGA32,  11,0592 MHz
'--------------------------------------------------------------

$regfile = "m32def.dat"
$baud = 19200
$crystal = 11059200
$hwstack = 32
$swstack = 64
$framesize = 64


Dim Command As Byte
Dim N As Byte
Dim L As Byte
Dim H As Byte
Dim D As Byte
Dim Dd As Word

Open "com1:" For Binary As #1

Config Portd = Output
Portc = 255


Config Adc = Single , Prescaler = Auto , Reference = Off    ' Pre 8...32
Start Adc

Config Timer1 = Pwm , Prescale = 8 , Pwm = 10 , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down
Start Timer1

Do
  Get #1 , Command
'SIOS Device 10
  If Command = 1 Then Put #1 , 10

'Firmware V2.1
  If Command = 2 Then Put #1 , 21

'Output Port D
  If Command = 16 Then
    Get #1 , D
    Portd = D
  End If

'Input Port C
  If Command = 32 Then
    D = Pinc
    Put # 1 , D
  End If

'ADC 8 Bit
  If Command = 48 Then
    Dd = Getadc(0)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If
  If Command = 49 Then
    Dd = Getadc(1)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If
  If Command = 50 Then
    Dd = Getadc(2)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If
  If Command = 51 Then
    Dd = Getadc(3)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If
  If Command = 52 Then
    Dd = Getadc(4)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If
  If Command = 53 Then
    Dd = Getadc(5)
    Shift Dd , Right , 2
    D = Dd
    Put #1 , D
  End If


'ADC  10 Bit
  If Command = 56 Then
    Dd = Getadc(0)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

  If Command = 57 Then
    Dd = Getadc(1)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

  If Command = 58 Then
    Dd = Getadc(2)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

  If Command = 59 Then
    Dd = Getadc(3)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

  If Command = 60 Then
    Dd = Getadc(4)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

  If Command = 61 Then
    Dd = Getadc(5)
    D = High(dd)
    Put #1 , D
    Get #1 , D
    D = Low(dd)
    Put #1 , D
  End If

'PWM Output 8 Bit
  If Command = 64 Then
    Get #1 , H
    Dd = 4 * H
    Pwm1a = Dd
  End If
  If Command = 65 Then
    Get #1 , H
    Dd = 4 * H
    Pwm1b = Dd
  End If

'PWM Output 10 Bit
  If Command = 72 Then
    Get #1 , H
    Dd = 256 * H
    Get #1 , L
    Dd = Dd + L
    Pwm1a = Dd
  End If
  If Command = 73 Then
    Get #1 , H
    Dd = 256 * H
    Get #1 , L
    Pwm1b = Dd
  End If
Loop

End