'Radio SI4735, Version 1, nur UKW mit RDS
'Ref-Clock an PD5 = PWMA
'Start bei 88,8 MHz
'S1 = Suchen -, S2 = Suchen +
'S3 = leiser, S3 = lauter

$regfile = "m32def.dat"
$baud = 19200
$crystal = 11059200
'$crystal = 3686000
$hwstack = 16
$swstack = 32
$framesize = 32

Dim N As Word
Dim D As Word
Dim I As Byte
Dim Am As Byte
Dim Ffm As Word
Dim Fam As Word
Dim T As Word
Dim T2 As Word
Dim Freq As Word
Dim Rssi As Word
Dim Snr As Word
Dim C As Word
Dim H As Byte
Dim L As Byte
Dim Vol As Byte
Dim Status As Byte
Dim R1 As Byte
Dim R2 As Byte
Dim R3 As Byte
Dim R4 As Byte
Dim R5 As Byte
Dim R6 As Byte
Dim R7 As Byte
Dim R8 As Byte
Dim R9 As Byte
Dim R10 As Byte
Dim R11 As Byte
Dim R12 As Byte
Dim R13 As Byte
Dim Bled As Byte
Dim Service As Byte
Dim Pos As Byte
Dim Ch As String * 1
Dim Tx As String * 2
Dim Utcoffset As Byte
Dim Minuten As Byte
Dim Stunden As Byte
Dim Lo As Byte
Dim Hi As Byte


S1 Alias Pind.2
S2 Alias Pind.3
S3 Alias Pind.6
S4 Alias Pind.7

Declare Sub Get_int_status()
Declare Sub Refclock()
Declare Sub Rx_volume()
Declare Sub Power_down();
Declare Sub Init_am()
Declare Sub Init_fm()
Declare Sub Am_tune_freq();
Declare Sub Fm_tune_freq();
Declare Sub Fm_seek_freq_up()
Declare Sub Fm_seek_freq_down()
Declare Sub Am_seek_freq_up()
Declare Sub Am_seek_freq_down()
Declare Sub Fm_tune_status()
Declare Sub Fm_rsq_status()
Declare Sub Am_tune_status()
Declare Sub Am_rsq_status()
Declare Sub Fm_start()
Declare Sub Am_start()
Declare Sub Am_seek_step_5khz()
Declare Sub Init_rds()
Declare Sub Fm_rds_status()
Declare Sub Rds()

'Config Pinb.3 = Output
'Tccr0 = &B00011001              ' Timer 0 CTC-Mode
'Ocr0 = 1                        ' Xtal/2/(OCR0+1)  2.764.800 Hz

'Config Pind.7 = Output
'Tccr2 = &B00011001              ' Timer 2 CTC-Mode
'Ocr2 = 1                        ' Xtal/2/(OCR0+1)  2.764.800 Hz


Config Lcdpin = Pin , Db4 = Portb.4 , Db5 = Portb.5 , Db6 = Portb.6 , Db7 = Portb.7 , E = Portb.3 , Rs = Portb.2
Config Lcd = 16 * 2
Initlcd
Cls


Config Timer1 = Counter , Prescale = 1 , Compare A = Toggle , Clear Timer = 1
Start Timer1
Pwm1a = 168                                                 'Xtal/2/(168+1) = 32720 Hz

Portd.2 = 1                                                 'Pullups s1...,s4
Portd.3 = 1
Portd.6 = 1
Portd.7 = 1

Ffm = 8880                                                  'Startfrequenz
Fam = 6075                                                  'Startfrequenz
Vol = 40                                                    'Lautstrke

Ddra.3 = 1
Waitms 100
Ddra.3 = 0
Waitms 100

Config Scl = Porta.1
Config Sda = Porta.2
I2cinit
Cursor Off

  Am = 1
  Am_start

  Do
    Waitms 1
    T = T + 1
    If T = 1000 Then T = 0
    If T = 900 Then
      If Am = 0 Then
        Rds
        Fm_rsq_status
      Else
        Am_tune_status
        'Am_rsq_status
      End If
    End If
    If S1 = 0 Then
      If Am = 0 Then                                        'T1: FM
        T2 = 0
        Waitms 5                                            'Entprellung
        Do
          Waitms 1
          T2 = T2 + 1
        Loop Until S1 = 1
        If T2 < 200 Then                                    'T1 kurz
          Fm_seek_freq_up
          Locate 2 , 1
          Lcd "                "
        Else                                                'T1 lang
          Fm_seek_freq_down
          Locate 2 , 1
          Lcd "                "
        End If
        Waitms 500
        Fm_tune_status
      Else
        Am = 0
        T = 0
        Power_down
        Waitms 10
        Fm_start
      End If
    End If

    If S2 = 0 Then                                          'T2: AM
      If Am = 1 Then
        T2 = 0
        Waitms 5                                            'Entprellung
        Do
          Waitms 1
          T2 = T2 + 1
        Loop Until S2 = 1
        If T2 < 200 Then                                    'T2 kurz
          Am_seek_freq_up
        Else                                                'T2 lang
          Am_seek_freq_down
        End If
        Waitms 500
        Am_tune_status
      Else
        Am = 1
        T = 0
        Power_down
        Waitms 10
        Am_start

      End If
    End If


    If S3 = 0 Then                                          'S3: leiser
        Vol = Vol - 1
        If Vol < 10 Then Vol = 10
        Waitms 50
        Rx_volume
    End If

    If S4 = 0 Then                                          'S4: lauter
        Vol = Vol + 1
        If Vol > 63 Then Vol = 63
        Waitms 50
        Rx_volume
    End If
  Loop


Sub Fm_start()
  Cls
  Init_fm
  Waitms 200
  Refclock
  Waitms 5
  Rx_volume
  Waitms 5
  Fm_tune_freq
  Waitms 500
  Fm_tune_status
  Waitms 5
  Init_rds
End Sub

Sub Am_start()
  Cls
  Init_am
  Waitms 200
  Refclock
  Waitms 5
  Rx_volume
  Waitms 5
  Am_tune_freq
  Waitms 500
  Am_seek_step_5khz
  Waitms 1
  Am_tune_status
End Sub

Sub Get_int_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H14
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Nack
  I2cstop
  Status = Status And 128
  Shift Status , Right , 7
End Sub

Sub Refclock()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12                                             'property
  I2cwbyte &H00
  I2cwbyte &H02
  I2cwbyte &H01
  D = 32720                                                 'Ref = 32914 Hz
  H = High(d)
  L = Low(d)
  I2cwbyte H
  I2cwbyte L
  I2cstop
End Sub


Sub Rx_volume()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H40
  I2cwbyte &H00
  I2cwbyte &H00
  I2cwbyte Vol
  I2cstop
End Sub

Sub Am_seek_step_5khz()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H34
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H05
  I2cstop
End Sub

Sub Power_down();
  I2cstart
  I2cwbyte 34
  I2cwbyte &H11
  I2cstop
End Sub

Sub Init_am()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H01
  I2cwbyte &H01
  I2cwbyte &H05
  I2cstop
End Sub

Sub Init_fm()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H01
  I2cwbyte &H00                                             '00 FM, 01 AM
  I2cwbyte &H05
  I2cstop
End Sub


Sub Init_rds()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H15
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H01
  I2cstop
End Sub




Sub Am_tune_freq();
  I2cstart
  I2cwbyte 34
  I2cwbyte &H40
  I2cwbyte &H00
  H = High(fam)
  L = Low(fam)
  I2cwbyte H
  I2cwbyte L
  I2cwbyte &H00
  I2cstop
End Sub

Sub Fm_tune_freq();
  I2cstart
  I2cwbyte 34
  I2cwbyte &H20
  I2cwbyte &H00
  H = High(ffm)
  L = Low(ffm)
  I2cwbyte H
  I2cwbyte L                                                '88,80 MHz
  I2cwbyte &H00
  I2cstop
End Sub

Sub Fm_seek_freq_up()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H21
  I2cwbyte &H0C
  I2cstop
End Sub


Sub Fm_seek_freq_down()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H21
  I2cwbyte &H04
  I2cstop
End Sub


Sub Am_seek_freq_up()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H41
  I2cwbyte &H0C
  I2cstop
End Sub


Sub Am_seek_freq_down()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H41
  I2cwbyte &H04
  I2cstop
End Sub



Sub Fm_tune_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H22
  I2cwbyte &H3
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  Freq = 256 * R2
  Freq = Freq + R3
  Rssi = R4
  Snr = R5
  Locate 1 , 1
  Lcd Freq
  Lcd " "
  Locate 1 , 7
  Lcd Rssi
  Lcd " "
  Locate 1 , 10
  Lcd Snr
  Lcd " "
  I2cstop
End Sub

Sub Fm_rsq_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H23
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
  Locate 1 , 7
  Lcd Rssi
  Lcd " "
  Locate 1 , 10
  Lcd Snr
  Lcd " "
End Sub

Sub Am_tune_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H42
  I2cwbyte &H01
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  Freq = 256 * R2
  Freq = Freq + R3
  Rssi = R4
  Snr = R5
  C = 256 * R6
  C = C + R7
  Locate 1 , 1
  Lcd Freq
  Lcd " "
  Locate 1 , 7
  Lcd Rssi
  Lcd " "
  Locate 1 , 10
  Lcd Snr
  Lcd " "
  Locate 1 , 13
  Lcd C
  Lcd "  "

  I2cstop
End Sub

Sub Am_rsq_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H43
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
  Locate 1 , 7
  Lcd Rssi
  Lcd " "
  Locate 1 , 10
  Lcd Snr
  Lcd " "
End Sub

Sub Fm_rds_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H24
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Ack
  I2crbyte R8 , Ack
  I2crbyte R9 , Ack
  I2crbyte R10 , Ack
  I2crbyte R11 , Ack
  I2crbyte R12 , Ack
  I2crbyte R13 , Nack
  I2cstop
End Sub


Sub Rds()
  For N = 1 To 15
    Get_int_status
    If Status = 1 Then
      Fm_rds_status
      If R3 > 0 Then                                        'neue Daten?
        Bled = R12 And 3
        Service = R6 And 248
        If Service = 0 Then                                 '0A, Tuning Information
          If Bled = 0 Then
            Pos = R7 And 3
            Pos = Pos * 2
            Pos = Pos + 1
            Locate 2 , Pos
            Ch = Chr(r10)
            Lcd Ch
            Ch = Chr(r11)
            Lcd Ch
          End If
        End If
        If Service = 64 Then                                '4A, Time
          Utcoffset = R11 And 31
          Utcoffset = Utcoffset / 2
          Lo = R11 / 64
          Hi = R10 And 15
          Hi = Hi * 4
          Minuten = Hi + Lo
          Lo = R10 / 16
          Hi = R9 And 1
          Hi = Hi * 16
          Stunden = Hi + Lo
          If R11.5 = 1 Then
            Stunden = Stunden - Utcoffset
          Else
            Stunden = Stunden + Utcoffset
          End If
          Locate 2 , 9
          Tx = Str(stunden)
          If Stunden < 10 Then
            Tx = "0" + Tx
          End If
          Lcd Tx
          Lcd ":"
          Tx = Str(minuten)
          If Minuten < 10 Then
            Tx = "0" + Tx
          End If
          Lcd Tx
        End If
      End If
    End If
  Next N
End Sub




End