'Radio SI4735, Version 1, nur UKW
'Ref-Clock an PD5 = PWMA
'Start bei 88,8 MHz
'S1 = Suchen -, S2 = Suchen +
'S3 = leiser, S3 = lauter

$regfile = "m32def.dat"
$baud = 19200
$crystal = 11059200
'$crystal = 3686000
$hwstack = 16
$swstack = 32
$framesize = 32

Dim N As Word
Dim D As Word
Dim I As Byte
Dim F As Word
Dim H As Byte
Dim L As Byte
Dim Vol As Byte

S1 Alias Pind.2
S2 Alias Pind.3
S3 Alias Pind.6
S4 Alias Pind.7


'Config Pinb.3 = Output
'Tccr0 = &B00011001              ' Timer 0 CTC-Mode
'Ocr0 = 1                        ' Xtal/2/(OCR0+1)  2.764.800 Hz

'Config Pind.7 = Output
'Tccr2 = &B00011001              ' Timer 2 CTC-Mode
'Ocr2 = 1                        ' Xtal/2/(OCR0+1)  2.764.800 Hz


Config Timer1 = Counter , Prescale = 1 , Compare A = Toggle , Clear Timer = 1
Start Timer1
Pwm1a = 1                                                   ' Xtal/2/(1+1) = 2.764.800 Hz

Portd.2 = 1                                                 'Pullups s1...,s4
Portd.3 = 1
Portd.6 = 1
Portd.7 = 1

F = 8880                                                    'Startfrequenz
Vol = 63                                                    'Lautstrke

Ddra.3 = 1
Waitms 100
Ddra.3 = 0
Waitms 100

Config Scl = Porta.1
Config Sda = Porta.2
I2cinit


    I2cstart
    I2cwbyte 34
    I2cwbyte &H01
    I2cwbyte &H00                                           '00 FM, 01 AM
    I2cwbyte &H05
    I2cstop

    Waitms 200

    I2cstart                                                'property
    I2cwbyte 34
    I2cwbyte &H12
    I2cwbyte &H00                                           'prescaler
    I2cwbyte &H02
    I2cwbyte &H02
    D = 84                                                  '/84
    H = High(d)
    L = Low(d)
    I2cwbyte H
    I2cwbyte L
    I2cstop

    Waitms 2

    I2cstart
    I2cwbyte 34
    I2cwbyte &H12                                           'property
    I2cwbyte &H00
    I2cwbyte &H02
    I2cwbyte &H01
    D = 32914                                               'Ref = 32914 Hz
    H = High(d)
    L = Low(d)
    I2cwbyte H
    I2cwbyte L
    I2cstop

    Waitms 200

    I2cstart
    I2cwbyte 34
    I2cwbyte &H20
    I2cwbyte &H00
    H = High(f)
    L = Low(f)
    I2cwbyte H
    I2cwbyte L                                              '88,80 MHz
    I2cwbyte &H00
    I2cstop

    Do
      If S1 = 0 Then                                        'Suchen  -
        I2cstart
        I2cwbyte 34
        I2cwbyte &H21
        I2cwbyte &H04
        I2cstop
        Waitms 500
      End If
      Do
      Loop Until S1 = 1

      If S2 = 0 Then                                        'Suchen  +
        I2cstart
        I2cwbyte 34
        I2cwbyte &H21
        I2cwbyte &H0C
        I2cstop
        Waitms 500
      End If
      Do
      Loop Until S2 = 1

      If S3 = 0 Then                                        'leiser
        Vol = Vol - 1
        If Vol < 10 Then Vol = 10
        Waitms 50
        I2cstart
        I2cwbyte 34
        I2cwbyte &H12
        I2cwbyte &H00
        I2cwbyte &H40
        I2cwbyte &H00
        I2cwbyte &H00
        I2cwbyte Vol
        I2cstop
      End If

      If S4 = 0 Then                                        'lauter
        Vol = Vol + 1
        If Vol > 63 Then Vol = 63
        Waitms 50
        I2cstart
        I2cwbyte 34
        I2cwbyte &H12
        I2cwbyte &H00
        I2cwbyte &H40
        I2cwbyte &H00
        I2cwbyte &H00
        I2cwbyte Vol
        I2cstop
      End If
    Loop



End