#Tk_GPIO10PWM.py Port 10 PWM-Ausgabe mit Schieberegler
from tkinter import *
import RPi.GPIO as GPIO
GPIO.setwarnings(False)
GPIO.setmode(GPIO.BCM)      # Broadcom
GPIO.setup(10, GPIO.OUT)    # Port 10 Ausgang
p = GPIO.PWM(10, 500)       # Port 10 PWM 500 Hz
p.start(0)                  # 0%

global d
d=0
global du
du=0

def anzeige(lb):
  global d
  lb.config(text="U = " + str(d) + " mV")
  lb.after(100, anzeige, lb)

def pwm_aus(sc):
  global d
  global du
  pwm=0.0
  d = sc.get()
  d=d+du
  if d>3300:
    d=3300
  if d<0:
    d=0 
  sc.set(d)
  pwm = d
  pwm=pwm/33.0
  p.ChangeDutyCycle(pwm)
  sc.after(500, pwm_aus, sc)

def hoch():
  global du
  du=5
def runter():
  global du
  du=-5
def stop():
  global du
  du=0

def f02():
  global p
  p.stop
  p.ChangeFrequency(0.2)      # Port 10 PWM 0,2 Hz
  p.start(0)                  # 0%
def f1():
  global p
  p.stop
  p.ChangeFrequency(1)        # Port 10 PWM 1 Hz
  p.start(0)                  # 0%
def f50():
  global p
  p.stop
  p.ChangeFrequency(50)       # Port 10 PWM 50 Hz
  p.start(0)                  # 0%
def f500():
  global p
  p.stop
  p.ChangeFrequency(500)      # Port 10 PWM 500 Hz
  p.start(0)                  # 0%
def f5000():
  global p
  p.stop
  p.ChangeFrequency(5000)     # Port 10 PWM 5000 Hz
  p.start(0)                  # 0%

def fstop():
  global p
  p.stop()
  
def on_closing():
    GPIO.cleanup()
    root.destroy()
               
  
root = Tk()
root.title("PWM GPIO 10")
root.font=("Helvetica", 30, "normal")
Label(root, text="------------------", font = root.font).pack()
lb = Label(root, font = root.font)
lb.pack()
Label(root, text="------------------", font = root.font).pack()
sc = Scale(root, from_=0, to=3300, length=500,tickinterval=500, orient=HORIZONTAL) 
sc.set(0)
sc.pack()
Button(root, text="+10 mV/s", width=20,command=hoch).pack()
Button(root, text="-10 mV/s",width=20, command=runter).pack()
Button(root, text="Stop",width=20, command=stop).pack()
Button(root, text="0.2 Hz",width=7, command=f02).pack(side=LEFT)
Button(root, text="1 Hz",width=7, command=f1).pack(side=LEFT)
Button(root, text="50 Hz",width=7, command=f50).pack(side=LEFT)
Button(root, text="500 Hz",width=7, command=f500).pack(side=LEFT)
Button(root, text="5 kHz",width=7, command=f5000).pack(side=LEFT)
Button(root, text="PWM Stop",width=7, command=fstop).pack()

anzeige(lb)
pwm_aus(sc)
root.protocol("WM_DELETE_WINDOW", on_closing)
root.mainloop()

