#Tk_GPIO9ADC11.py  GPIO11/9 ADC -5V...+5V
from tkinter import *
from time import sleep
import RPi.GPIO as GPIO
GPIO.setwarnings(False)
GPIO.setmode(GPIO.BCM)   
GPIO.setup(9, GPIO.OUT)  
GPIO.setup(11, GPIO.IN)

def run_adc(lb):
    GPIO.output(9, 0)
    sleep(0.05)
    u1=0
    u2=0
    while not GPIO.input(11):
        GPIO.output(9, 1)
        u1=u1+1
        if u1>1000:
            break
    u1=0
    for i in range(300000):
        if GPIO.input(11):
            GPIO.output(9, 0)
            u1=u1+1
        else:
            GPIO.output(9, 1)
            u2=u2+1
    u=u1-u2
    u=u*982   #Endwert kalibireren
    u=u/60000
    u=u-110     #Nullpukt kalibrieren
    u=int(u)
    lb.config(text="U = " + str(u) + " mV")
    lb.after(100, run_adc, lb)

root = Tk()
root.font=("Helvetica", 30, "normal")
root.title("ADC GPIO9/11")
Label(root, text="---------------------", font = root.font).pack()
lb = Label(root)
lb.config(text="U = 0 mV", font = root.font)
lb.pack()
Label(root, text="---------------------", font = root.font).pack()
Label(root, text="-5000 mV ... +5000 mV").pack()

run_adc(lb)
mainloop()




