#Tk_GPIO22RC.py  RC-Messung
from Tkinter import *
import RPi.GPIO as GPIO
import time
GPIO.setwarnings(False) 
GPIO.setmode(GPIO.BCM)   

def rc(lb):
    GPIO.setup(22, GPIO.OUT)
    GPIO.output(22, 1)
    time.sleep(0.05)
    GPIO.setup(22, GPIO.IN)   
    t0=time.time()
    while GPIO.input(22) > 0:
        t1=time.time()
        if (t1-t0)>1:
            break
    t1=time.time()
    t=(t1-t0)*1000000
    t=int(t)
    lb.config(text="t = " + str(t) + " us")
    lb.after(500, rc, lb)

root = Tk()
root.font=('Helvetica', 30, 'normal')
root.title("RC GPIO 22")
Label(root, text="---------------------", font = root.font).pack()
lb = Label(root)
lb.config(text="t = 0 us", font = root.font)
lb.pack()
Label(root, text="---------------------", font = root.font).pack()
rc(lb)
mainloop()




