' AT45 Flash1, Blitz counter 10 ms
'
' GS 2013/8
' Ledpulse turned on 100 ms
' Ledhigh turned on 1 sec
' 10 ms sampling time
' threshold to eliminate noise
'
'***************************************************************************
'  This program is free software; you can redistribute it and/or
'  modify it under the terms of the GNU General Public License.
'  This program is distributed in the hope that it will be useful,
'  but WITHOUT ANY WARRANTY;
'***************************************************************************
'
'                            ATtiny45 dip
' (PCINT5/RESET/ADC0/dW)         PB5  VCC
' (PCINT3/XTAL1/CLKI/OC1B/ADC3)  PB3  PB2 (SCK/USCK/SCL/ADC1/T0/INT0/PCINT2)
' (PCINT4/XTAL2/CLKO/OC1B/ADC2)  PB4  PB1 (MISO/DO/AIN1/OC0B/OC1A/PCINT1)
'                                GND  PB0 (MOSI/DI/SDA/AIN0/OC0A/OC1A/AREF/PCINT0)
'
';***************************************************************************
' PB0 output  Ledpulse, hi
' PB1 output  Ledhigh, hi
' PB2 input   T0 Counter
' PB4 output  Com1
' PB3 output  Ledhigh1, hi
'***************************************************************************

$regfile = "attiny45.dat"
$crystal = 1000000
'$crystal = 8000000
$hwstack = 8
$swstack = 8
$framesize = 4

'Ipulse Alias Portb.3
Ledpulse Alias Portb.0
Ledhigh Alias Portb.1
Ledhigh1 Alias Portb.3

Const C_value = 156 - 1                                     ' Compare Match IRQ 10 ms
Const Threshval = 2                                         'Threshold noise
Const Threshval1 = 16                                       'Threshold high
Const Threshval2 = 32                                       'Threshold high2

Dim Cntflash As Word , Icnt As Word
Dim T0cnt As Byte
Dim Alarmflag As Byte , Alarmflag1 As Byte , Alarmflag2 As Byte
Dim Dcnt As Byte , Dcnt1 As Byte , Dcnt2 As Byte

Portb = &B00000100
Ddrb = &B00011011

'CLKPR = &B10000000 'Clock Prescaler Change Enable
'CLKPR = &B00000000 'Clock Division Factor=0, 8 MHz

Config Timer1 = Timer , Prescale = 64
Tccr1 = &B10000111                                          'ctc & value for 1.0 MHz
Ocr1a = C_value                                             '
Ocr1c = C_value                                             '
Timsk.ocie1a = 1
On Oc1a Tim1_compa
'Start Timer1

Acsr.acd = 0                                                ' switch off analog comparator

Open "comb.4:9600,8,n,1,INVERTED" For Output As #1

Config Timer0 = Counter , Edge = Falling
Tcnt0 = 0
Start Timer0

Enable Interrupts

'test leds
Ledpulse = 1                                                ' Led on
Waitms 200
Ledhigh = 1                                                 ' Led on
Waitms 200
Ledhigh1 = 1                                                ' Led on
Waitms 200
Ledpulse = 0
Ledhigh = 0
Ledhigh1 = 0


Do

If Icnt = 100 Then
  Icnt = 0
  Print #1 , Cntflash
  Cntflash = 0
End If

Loop

'***************************************************************************
'Tim1_compa Interrupt  10 ms
'***************************************************************************
Tim1_compa:                                                 '10 ms

  T0cnt = Tcnt0
  Tcnt0 = 0
'  Ipulse = 1
  Incr Icnt

  If T0cnt > Threshval Then                                 'noise
    Cntflash = Cntflash + T0cnt
    Alarmflag = 1
  End If

  If T0cnt > Threshval1 Then                                'high
    Alarmflag1 = 1
  End If

  If T0cnt > Threshval2 Then                                'high2
    Alarmflag2 = 1
  End If

  If Alarmflag = 1 Then                                     'sw monoflop
    Ledpulse = 1                                            ' Led on
    Incr Dcnt
    If Dcnt > 10 Then                                       'reset sw monoflop
       Ledpulse = 0
       Alarmflag = 0
       Dcnt = 0
    End If
  End If                                                    'if Alarmflag = 1

  If Alarmflag1 = 1 Then                                    'sw monoflop
    Ledhigh = 1
    Incr Dcnt1
    If Dcnt1 > 100 Then                                     'reset sw monoflop
       Ledhigh = 0
       Alarmflag1 = 0
       Dcnt1 = 0
    End If
  End If                                                    'if Alarmflag1 = 1

  If Alarmflag2 = 1 Then                                    'sw monoflop
    Ledhigh1 = 1
    Incr Dcnt2
    If Dcnt2 > 150 Then                                     'reset sw monoflop
       Ledhigh1 = 0
       Alarmflag2 = 0
       Dcnt2 = 0
    End If
  End If                                                    'if Alarmflag1 = 1
'  Ipulse = 0

Return


End