byte const ascii[][8] PROGMEM = {
  {
    // 0  0x00     NUL (Null)
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 1  0x01     SOH (Start of Header)
    0b00011100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00110110,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 2  0x02     STX (Start of Text)
    0b00011100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00100010,
    0b00110110,
    0b00011100,
    0b00000000
},{
    // 3  0x03     ETX (End of Text)
    0b00000000,
    0b00010100,
    0b00111110,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 4  0x04     EOT (End of Transmission)
    0b00000000,
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 5  0x05     ENQ (Enquiry)
    0b00011100,
    0b00010100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 6  0x06     ACK (Acknowledge)
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00111110,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 7  0x07     BEL (Bell)
    0b00000000,
    0b00000000,
    0b00001000,
    0b00011100,
    0b00011100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 8  0x08     BS  (BackSpace)
    0b00111110,
    0b00111110,
    0b00110110,
    0b00100010,
    0b00100010,
    0b00110110,
    0b00111110,
    0b00111110
},{
    // 9  0x09     HT  (Horizontal Tabulation)
    0b00000000,
    0b00000000,
    0b00001000,
    0b00010100,
    0b00010100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 10  0x0A     LF  (Line Feed)
    0b00111110,
    0b00111110,
    0b00110110,
    0b00101010,
    0b00101010,
    0b00110110,
    0b00111110,
    0b00111110
},{
    // 11  0x0B     VT  (Vertical Tabulation)
    0b00000000,
    0b00001110,
    0b00000110,
    0b00011010,
    0b00101000,
    0b00101000,
    0b00010000,
    0b00000000
},{
    // 12  0x0C     FF  (Form Feed)
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00000000
},{
    // 13  0x0D     CR  (Carriage Return)
    0b00011110,
    0b00010010,
    0b00011110,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00110000,
    0b00000000
},{
    // 14  0x0E     SO  (Shift Out)
    0b00011110,
    0b00010010,
    0b00011110,
    0b00010010,
    0b00010010,
    0b00010110,
    0b00110000,
    0b00000000
},{
    // 15  0x0F     SI  (Shift In)
    0b00001000,
    0b00101010,
    0b00011100,
    0b00110110,
    0b00110110,
    0b00011100,
    0b00101010,
    0b00001000
},{
    // 16  0x10     DLE (Data Link Escape)
    0b00100000,
    0b00110000,
    0b00111100,
    0b00111110,
    0b00111100,
    0b00110000,
    0b00100000,
    0b00000000
},{
    // 17  0x11     DC1 (Device Control 1)
    0b00000010,
    0b00000110,
    0b00011110,
    0b00111110,
    0b00011110,
    0b00000110,
    0b00000010,
    0b00000000
},{
    // 18  0x12     DC2 (Device Control 2)
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 19  0x13     DC3 (Device Control 3)
    0b00110110,
    0b00110110,
    0b00110110,
    0b00110110,
    0b00110110,
    0b00000000,
    0b00110110,
    0b00000000
},{
    // 20  0x14     DC4 (Device Control 4)
    0b00011110,
    0b00101010,
    0b00101010,
    0b00011010,
    0b00001010,
    0b00001010,
    0b00001010,
    0b00000000
},{
    // 21  0x15     NAK (Negative Acknowledge)
    0b00001100,
    0b00010010,
    0b00010100,
    0b00001010,
    0b00000100,
    0b00010010,
    0b00010010,
    0b00001100
},{
    // 22  0x16     SYN (Synchronous Idle)
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00111110,
    0b00000000
},{
    // 23  0x17     ETB (End of Transmission Block)
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00111110
},{
    // 24  0x18     CAN (Cancel)
    0b00000000,
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 25  0x19     EM  (End of Medium)
    0b00000000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 26  0x1A     SUB (Substitute)
    0b00000000,
    0b00001000,
    0b00000100,
    0b00111110,
    0b00000100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 27  0x1B     ESC (Escape)
    0b00000000,
    0b00001000,
    0b00010000,
    0b00111110,
    0b00010000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 28  0x1C     FS  (File Separator)
    0b00000000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 29  0x1D     GS  (Group Separator)
    0b00000000,
    0b00010100,
    0b00111110,
    0b00111110,
    0b00010100,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 30  0x1E     RS  (Record Separator)
    0b00000000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00000000,
    0b00000000
},{
    // 31  0x1F     US  (Unit Separator)
    0b00000000,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 32  0x20     Space
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 33  0x21  !  Exclamation mark
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000
},{
    // 34  0x22  "  Quotation Mark
    0b00010100,
    0b00010100,
    0b00010100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 35  0x23
    0b00010100,
    0b00010100,
    0b00111110,
    0b00010100,
    0b00111110,
    0b00010100,
    0b00010100,
    0b00000000
},{
    // 36  0x24  $  Dollar
    0b00001000,
    0b00011110,
    0b00101000,
    0b00011100,
    0b00001010,
    0b00111100,
    0b00001000,
    0b00000000
},{
    // 37  0x25  %  Percent
    0b00110000,
    0b00110010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100110,
    0b00000110,
    0b00000000
},{
    // 38  0x26  &  Ampersand
    0b00010000,
    0b00101000,
    0b00101000,
    0b00010000,
    0b00101010,
    0b00100100,
    0b00011010,
    0b00000000
},{
    // 39  0x27  '  Apostrophe
    0b00001100,
    0b00001100,
    0b00001000,
    0b00010000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 40  0x28  (  Open bracket
    0b00000100,
    0b00001000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000000
},{
    // 41  0x29  )  Close bracket
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 42  0x2A  *  Asterisk
    0b00001000,
    0b00101010,
    0b00011100,
    0b00111110,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00000000
},{
    // 43  0x2B  +  Plus
    0b00000000,
    0b00001000,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 44  0x2C  ,  Comma
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00001100,
    0b00001100,
    0b00001000,
    0b00010000
},{
    // 45  0x2D  -  Dash
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 46  0x2E  0  Full stop
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00001100,
    0b00001100,
    0b00000000
},{
    // 47  0x2F  /  Slash
    0b00000000,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100000,
    0b00000000,
    0b00000000
},{
    // 48  0x30  0  Zero
    0b00011100,
    0b00100010,
    0b00100110,
    0b00101010,
    0b00110010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 49  0x31  1  One
    0b00001000,
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 50  0x32  2  Two
    0b00011100,
    0b00100010,
    0b00000010,
    0b00011100,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 51  0x33  3  Three
    0b00111110,
    0b00000010,
    0b00000100,
    0b00001100,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 52  0x34  4  Four
    0b00000100,
    0b00001100,
    0b00010100,
    0b00100100,
    0b00111110,
    0b00000100,
    0b00000100,
    0b00000000
},{
    // 53  0x35  5  Five
    0b00111110,
    0b00100000,
    0b00111100,
    0b00000010,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 54  0x36  6  Six
    0b00001110,
    0b00010000,
    0b00100000,
    0b00111100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 55  0x37  7  Seven
    0b00111110,
    0b00000010,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100000,
    0b00000000
},{
    // 56  0x38  8  Eight
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 57  0x39  9  Nine
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011110,
    0b00000010,
    0b00000100,
    0b00111000,
    0b00000000
},{
    // 58  0x3A  :  Colon
    0b00000000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 59  0x3B  ;  Semicolon
    0b00000000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 60  0x3C  <  Less than
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000000
},{
    // 61  0x3D  =  Equals sign
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 62  0x3E  >  Greater than
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 63  0x3F  ?  Question mark
    0b00011100,
    0b00100010,
    0b00000010,
    0b00001100,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000
},{
    // 64  0x40  @  At
    0b00011100,
    0b00100010,
    0b00101010,
    0b00101110,
    0b00101100,
    0b00100000,
    0b00011110,
    0b00000000
},{
    // 65  0x41  A  Upper case A
    0b00001000,
    0b00010100,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 66  0x42  B  Upper case B
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00000000
},{
    // 67  0x43  C  Upper case C
    0b00011100,
    0b00100010,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 68  0x44  D  Upper case D
    0b00111100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00000000
},{
    // 69  0x45  E  Upper case E
    0b00111110,
    0b00100000,
    0b00100000,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 70  0x46  F  Upper case F
    0b00111110,
    0b00100000,
    0b00100000,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 71  0x47  G  Upper case G
    0b00011110,
    0b00100010,
    0b00100000,
    0b00100000,
    0b00100110,
    0b00100010,
    0b00011110,
    0b00000000
},{
    // 72  0x48  H  Upper case H
    0b00100010,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 73  0x49  I  Upper case I
    0b00011100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 74  0x4A  J  Upper case J
    0b00001110,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00100100,
    0b00011000,
    0b00000000
},{
    // 75  0x4B  K  Upper case K
    0b00100010,
    0b00100100,
    0b00101000,
    0b00110000,
    0b00101000,
    0b00100100,
    0b00100010,
    0b00000000
},{
    // 76  0x4C  L  Upper case L
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 77  0x4D  M  Upper case M
    0b00100010,
    0b00110110,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 78  0x4E  N  Upper case N
    0b00100010,
    0b00100010,
    0b00110010,
    0b00101010,
    0b00100110,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 79  0x4F  O  Upper case O
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 80  0x50  P  Upper case P
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 81  0x51  Q  Upper case Q
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00100100,
    0b00011010,
    0b00000000
},{
    // 82  0x52  R  Upper case R
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00101000,
    0b00100100,
    0b00100010,
    0b00000000
},{
    // 83  0x53  S  Upper case S
    0b00011100,
    0b00100010,
    0b00100000,
    0b00011100,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 84  0x54  T  Upper case T
    0b00111110,
    0b00101010,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 85  0x55  U  Upper case U
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 86  0x56  V  Upper case V
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00000000
},{
    // 87  0x57  W  Upper case W
    0b00100010,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00010100,
    0b00000000
},{
    // 88  0x58  X  Upper case X
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00010100,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 89  0x59  Y  Upper case Y
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 90  0x5A  Z  Upper case Z
    0b00111110,
    0b00000010,
    0b00000100,
    0b00011100,
    0b00010000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 91  0x5B  [  Open square bracket
    0b00011110,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00011110,
    0b00000000
},{
    // 92  0x5C  \  Backslash
    0b00000000,
    0b00100000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000000,
    0b00000000
},{
    // 93  0x5D  ]  Close square bracket
    0b00011110,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00011110,
    0b00000000
},{
    // 94  0x5E  ^  Caret
    0b00001000,
    0b00010100,
    0b00100010,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 95  0x5F  _  Underscore
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000
},{
    // 96  0x60  @  Grave accent
    0b00011000,
    0b00011000,
    0b00001000,
    0b00000100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 97  0x61  a  Lower case a
    0b00000000,
    0b00000000,
    0b00011000,
    0b00000100,
    0b00011100,
    0b00100100,
    0b00011110,
    0b00000000
},{
    // 98  0x62  b  Lower case b
    0b00100000,
    0b00100000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00110010,
    0b00101100,
    0b00000000
},{
    // 99  0x63  c  Lower case c
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00100000,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 100  0x64  d  Lower case d
    0b00000010,
    0b00000010,
    0b00011010,
    0b00100110,
    0b00100010,
    0b00100110,
    0b00011010,
    0b00000000
},{
    // 101  0x65  e  Lower case e
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00111110,
    0b00100000,
    0b00011100,
    0b00000000
},{
    // 102  0x66  f  Lower case f
    0b00000100,
    0b00001010,
    0b00001000,
    0b00011100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 103  0x67  g  Lower case g
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100110,
    0b00100110,
    0b00011010,
    0b00000010,
    0b00011100
},{
    // 104  0x68  h  Lower case h
    0b00100000,
    0b00100000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 105  0x69  i  Lower case i
    0b00001000,
    0b00000000,
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 106  0x6A  j  Lower case j
    0b00000100,
    0b00000000,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00100100,
    0b00011000,
    0b00000000
},{
    // 107  0x6B  k  Lower case k
    0b00100000,
    0b00100000,
    0b00100100,
    0b00101000,
    0b00110000,
    0b00101000,
    0b00100100,
    0b00000000
},{
    // 108  0x6C  l  Lower case l
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 109  0x6D  m  Lower case m
    0b00000000,
    0b00000000,
    0b00110100,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00000000
},{
    // 110  0x6E  n  Lower case n
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 111  0x6F  o  Lower case o
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 112  0x70  p  Lower case p
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00110010,
    0b00101100,
    0b00100000,
    0b00100000
},{
    // 113  0x71  q  Lower case q
    0b00000000,
    0b00000000,
    0b00011010,
    0b00100110,
    0b00100110,
    0b00011010,
    0b00000010,
    0b00000010,
},{
    // 114  0x72  r  Lower case r
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 115  0x73  s  Lower case s
    0b00000000,
    0b00000000,
    0b00011110,
    0b00100000,
    0b00011100,
    0b00000010,
    0b00111100,
    0b00000000
},{
    // 116  0x74  t  Lower case t
    0b00001000,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00001000,
    0b00001010,
    0b00000100,
    0b00000000
},{
    // 117  0x75  u  Lower case u
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100110,
    0b00011010,
    0b00000000
},{
    // 118  0x76  v  Lower case v
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00000000
},{
    // 119  0x77  w  Lower case w
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00101010,
    0b00010100,
    0b00000000
},{
    // 120  0x78  x  Lower case x
    0b00000000,
    0b00000000,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00010100,
    0b00100010,
    0b00000000
},{
    // 121  0x79  y  Lower case y
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00011110,
    0b00000010,
    0b00100010,
    0b00011100
},{
    // 122  0x7A  z  Lower case z
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00111110,
    0b00000000
},{
    // 123  0x7B  {  Open brace
    0b00000100,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00001000,
    0b00001000,
    0b00000100,
    0b00000000
},{
    // 124  0x7C  |  Pipe
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 125  0x7D  }  Close brace
    0b00010000,
    0b00001000,
    0b00001000,
    0b00000100,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 126  0x7E  ~  Tilde
    0b00010000,
    0b00101010,
    0b00000100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 127  0x7F     Delete
    0b00001000,
    0b00011100,
    0b00110110,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00000000,
    0b00000000
},{
    // 0  0x00     NUL (Null)
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 1  0x01     SOH (Start of Header)
    0b00011100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00110110,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 2  0x02     STX (Start of Text)
    0b00011100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00100010,
    0b00110110,
    0b00011100,
    0b00000000
},{
    // 3  0x03     ETX (End of Text)
    0b00000000,
    0b00010100,
    0b00111110,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 4  0x04     EOT (End of Transmission)
    0b00000000,
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 5  0x05     ENQ (Enquiry)
    0b00011100,
    0b00010100,
    0b00111110,
    0b00101010,
    0b00111110,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 6  0x06     ACK (Acknowledge)
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00111110,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 7  0x07     BEL (Bell)
    0b00000000,
    0b00000000,
    0b00001000,
    0b00011100,
    0b00011100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 8  0x08     BS  (BackSpace)
    0b00111110,
    0b00111110,
    0b00110110,
    0b00100010,
    0b00100010,
    0b00110110,
    0b00111110,
    0b00111110
},{
    // 9  0x09     HT  (Horizontal Tabulation)
    0b00000000,
    0b00000000,
    0b00001000,
    0b00010100,
    0b00010100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 10  0x0A     LF  (Line Feed)
    0b00111110,
    0b00111110,
    0b00110110,
    0b00101010,
    0b00101010,
    0b00110110,
    0b00111110,
    0b00111110
},{
    // 11  0x0B     VT  (Vertical Tabulation)
    0b00000000,
    0b00001110,
    0b00000110,
    0b00011010,
    0b00101000,
    0b00101000,
    0b00010000,
    0b00000000
},{
    // 12  0x0C     FF  (Form Feed)
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00000000
},{
    // 13  0x0D     CR  (Carriage Return)
    0b00011110,
    0b00010010,
    0b00011110,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00110000,
    0b00000000
},{
    // 14  0x0E     SO  (Shift Out)
    0b00011110,
    0b00010010,
    0b00011110,
    0b00010010,
    0b00010010,
    0b00010110,
    0b00110000,
    0b00000000
},{
    // 15  0x0F     SI  (Shift In)
    0b00001000,
    0b00101010,
    0b00011100,
    0b00110110,
    0b00110110,
    0b00011100,
    0b00101010,
    0b00001000
},{
    // 16  0x10     DLE (Data Link Escape)
    0b00100000,
    0b00110000,
    0b00111100,
    0b00111110,
    0b00111100,
    0b00110000,
    0b00100000,
    0b00000000
},{
    // 17  0x11     DC1 (Device Control 1)
    0b00000010,
    0b00000110,
    0b00011110,
    0b00111110,
    0b00011110,
    0b00000110,
    0b00000010,
    0b00000000
},{
    // 18  0x12     DC2 (Device Control 2)
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 19  0x13     DC3 (Device Control 3)
    0b00110110,
    0b00110110,
    0b00110110,
    0b00110110,
    0b00110110,
    0b00000000,
    0b00110110,
    0b00000000
},{
    // 20  0x14     DC4 (Device Control 4)
    0b00011110,
    0b00101010,
    0b00101010,
    0b00011010,
    0b00001010,
    0b00001010,
    0b00001010,
    0b00000000
},{
    // 21  0x15     NAK (Negative Acknowledge)
    0b00001100,
    0b00010010,
    0b00010100,
    0b00001010,
    0b00000100,
    0b00010010,
    0b00010010,
    0b00001100
},{
    // 22  0x16     SYN (Synchronous Idle)
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00111110,
    0b00000000
},{
    // 23  0x17     ETB (End of Transmission Block)
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00111110
},{
    // 24  0x18     CAN (Cancel)
    0b00000000,
    0b00001000,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 25  0x19     EM  (End of Medium)
    0b00000000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00101010,
    0b00011100,
    0b00001000,
    0b00000000
},{
    // 26  0x1A     SUB (Substitute)
    0b00000000,
    0b00001000,
    0b00000100,
    0b00111110,
    0b00000100,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 27  0x1B     ESC (Escape)
    0b00000000,
    0b00001000,
    0b00010000,
    0b00111110,
    0b00010000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 28  0x1C     FS  (File Separator)
    0b00000000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 29  0x1D     GS  (Group Separator)
    0b00000000,
    0b00010100,
    0b00111110,
    0b00111110,
    0b00010100,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 30  0x1E     RS  (Record Separator)
    0b00000000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00111110,
    0b00111110,
    0b00000000,
    0b00000000
},{
    // 31  0x1F     US  (Unit Separator)
    0b00000000,
    0b00111110,
    0b00111110,
    0b00011100,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 32  0x20     Space
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 33  0x21  !  Exclamation mark
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000
},{
    // 34  0x22  "  Quotation Mark
    0b00010100,
    0b00010100,
    0b00010100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 35  0x23
    0b00010100,
    0b00010100,
    0b00111110,
    0b00010100,
    0b00111110,
    0b00010100,
    0b00010100,
    0b00000000
},{
    // 36  0x24  $  Dollar
    0b00001000,
    0b00011110,
    0b00101000,
    0b00011100,
    0b00001010,
    0b00111100,
    0b00001000,
    0b00000000
},{
    // 37  0x25  %  Percent
    0b00110000,
    0b00110010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100110,
    0b00000110,
    0b00000000
},{
    // 38  0x26  &  Ampersand
    0b00010000,
    0b00101000,
    0b00101000,
    0b00010000,
    0b00101010,
    0b00100100,
    0b00011010,
    0b00000000
},{
    // 39  0x27  '  Apostrophe
    0b00001100,
    0b00001100,
    0b00001000,
    0b00010000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 40  0x28  (  Open bracket
    0b00000100,
    0b00001000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000000
},{
    // 41  0x29  )  Close bracket
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 42  0x2A  *  Asterisk
    0b00001000,
    0b00101010,
    0b00011100,
    0b00111110,
    0b00011100,
    0b00101010,
    0b00001000,
    0b00000000
},{
    // 43  0x2B  +  Plus
    0b00000000,
    0b00001000,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00000000
},{
    // 44  0x2C  ,  Comma
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00001100,
    0b00001100,
    0b00001000,
    0b00010000
},{
    // 45  0x2D  -  Dash
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 46  0x2E  0  Full stop
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00001100,
    0b00001100,
    0b00000000
},{
    // 47  0x2F  /  Slash
    0b00000000,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100000,
    0b00000000,
    0b00000000
},{
    // 48  0x30  0  Zero
    0b00011100,
    0b00100010,
    0b00100110,
    0b00101010,
    0b00110010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 49  0x31  1  One
    0b00001000,
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 50  0x32  2  Two
    0b00011100,
    0b00100010,
    0b00000010,
    0b00011100,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 51  0x33  3  Three
    0b00111110,
    0b00000010,
    0b00000100,
    0b00001100,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 52  0x34  4  Four
    0b00000100,
    0b00001100,
    0b00010100,
    0b00100100,
    0b00111110,
    0b00000100,
    0b00000100,
    0b00000000
},{
    // 53  0x35  5  Five
    0b00111110,
    0b00100000,
    0b00111100,
    0b00000010,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 54  0x36  6  Six
    0b00001110,
    0b00010000,
    0b00100000,
    0b00111100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 55  0x37  7  Seven
    0b00111110,
    0b00000010,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00100000,
    0b00000000
},{
    // 56  0x38  8  Eight
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 57  0x39  9  Nine
    0b00011100,
    0b00100010,
    0b00100010,
    0b00011110,
    0b00000010,
    0b00000100,
    0b00111000,
    0b00000000
},{
    // 58  0x3A  :  Colon
    0b00000000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 59  0x3B  ;  Semicolon
    0b00000000,
    0b00000000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 60  0x3C  <  Less than
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000000
},{
    // 61  0x3D  =  Equals sign
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00111110,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 62  0x3E  >  Greater than
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 63  0x3F  ?  Question mark
    0b00011100,
    0b00100010,
    0b00000010,
    0b00001100,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00000000
},{
    // 64  0x40  @  At
    0b00011100,
    0b00100010,
    0b00101010,
    0b00101110,
    0b00101100,
    0b00100000,
    0b00011110,
    0b00000000
},{
    // 65  0x41  A  Upper case A
    0b00001000,
    0b00010100,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 66  0x42  B  Upper case B
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00000000
},{
    // 67  0x43  C  Upper case C
    0b00011100,
    0b00100010,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 68  0x44  D  Upper case D
    0b00111100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00000000
},{
    // 69  0x45  E  Upper case E
    0b00111110,
    0b00100000,
    0b00100000,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 70  0x46  F  Upper case F
    0b00111110,
    0b00100000,
    0b00100000,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 71  0x47  G  Upper case G
    0b00011110,
    0b00100010,
    0b00100000,
    0b00100000,
    0b00100110,
    0b00100010,
    0b00011110,
    0b00000000
},{
    // 72  0x48  H  Upper case H
    0b00100010,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 73  0x49  I  Upper case I
    0b00011100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 74  0x4A  J  Upper case J
    0b00001110,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00100100,
    0b00011000,
    0b00000000
},{
    // 75  0x4B  K  Upper case K
    0b00100010,
    0b00100100,
    0b00101000,
    0b00110000,
    0b00101000,
    0b00100100,
    0b00100010,
    0b00000000
},{
    // 76  0x4C  L  Upper case L
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 77  0x4D  M  Upper case M
    0b00100010,
    0b00110110,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 78  0x4E  N  Upper case N
    0b00100010,
    0b00100010,
    0b00110010,
    0b00101010,
    0b00100110,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 79  0x4F  O  Upper case O
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 80  0x50  P  Upper case P
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 81  0x51  Q  Upper case Q
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00100100,
    0b00011010,
    0b00000000
},{
    // 82  0x52  R  Upper case R
    0b00111100,
    0b00100010,
    0b00100010,
    0b00111100,
    0b00101000,
    0b00100100,
    0b00100010,
    0b00000000
},{
    // 83  0x53  S  Upper case S
    0b00011100,
    0b00100010,
    0b00100000,
    0b00011100,
    0b00000010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 84  0x54  T  Upper case T
    0b00111110,
    0b00101010,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 85  0x55  U  Upper case U
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 86  0x56  V  Upper case V
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00000000
},{
    // 87  0x57  W  Upper case W
    0b00100010,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00010100,
    0b00000000
},{
    // 88  0x58  X  Upper case X
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00010100,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 89  0x59  Y  Upper case Y
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 90  0x5A  Z  Upper case Z
    0b00111110,
    0b00000010,
    0b00000100,
    0b00011100,
    0b00010000,
    0b00100000,
    0b00111110,
    0b00000000
},{
    // 91  0x5B  [  Open square bracket
    0b00011110,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00011110,
    0b00000000
},{
    // 92  0x5C  \  Backslash
    0b00000000,
    0b00100000,
    0b00010000,
    0b00001000,
    0b00000100,
    0b00000010,
    0b00000000,
    0b00000000
},{
    // 93  0x5D  ]  Close square bracket
    0b00011110,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00000010,
    0b00011110,
    0b00000000
},{
    // 94  0x5E  ^  Caret
    0b00001000,
    0b00010100,
    0b00100010,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 95  0x5F  _  Underscore
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000000
},{
    // 96  0x60  @  Grave accent
    0b00011000,
    0b00011000,
    0b00001000,
    0b00000100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 97  0x61  a  Lower case a
    0b00000000,
    0b00000000,
    0b00011000,
    0b00000100,
    0b00011100,
    0b00100100,
    0b00011110,
    0b00000000
},{
    // 98  0x62  b  Lower case b
    0b00100000,
    0b00100000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00110010,
    0b00101100,
    0b00000000
},{
    // 99  0x63  c  Lower case c
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00100000,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 100  0x64  d  Lower case d
    0b00000010,
    0b00000010,
    0b00011010,
    0b00100110,
    0b00100010,
    0b00100110,
    0b00011010,
    0b00000000
},{
    // 101  0x65  e  Lower case e
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00111110,
    0b00100000,
    0b00011100,
    0b00000000
},{
    // 102  0x66  f  Lower case f
    0b00000100,
    0b00001010,
    0b00001000,
    0b00011100,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 103  0x67  g  Lower case g
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100110,
    0b00100110,
    0b00011010,
    0b00000010,
    0b00011100
},{
    // 104  0x68  h  Lower case h
    0b00100000,
    0b00100000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 105  0x69  i  Lower case i
    0b00001000,
    0b00000000,
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 106  0x6A  j  Lower case j
    0b00000100,
    0b00000000,
    0b00000100,
    0b00000100,
    0b00000100,
    0b00100100,
    0b00011000,
    0b00000000
},{
    // 107  0x6B  k  Lower case k
    0b00100000,
    0b00100000,
    0b00100100,
    0b00101000,
    0b00110000,
    0b00101000,
    0b00100100,
    0b00000000
},{
    // 108  0x6C  l  Lower case l
    0b00011000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00011100,
    0b00000000
},{
    // 109  0x6D  m  Lower case m
    0b00000000,
    0b00000000,
    0b00110100,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00101010,
    0b00000000
},{
    // 110  0x6E  n  Lower case n
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00000000
},{
    // 111  0x6F  o  Lower case o
    0b00000000,
    0b00000000,
    0b00011100,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00011100,
    0b00000000
},{
    // 112  0x70  p  Lower case p
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00110010,
    0b00101100,
    0b00100000,
    0b00100000
},{
    // 113  0x71  q  Lower case q
    0b00000000,
    0b00000000,
    0b00011010,
    0b00100110,
    0b00100110,
    0b00011010,
    0b00000010,
    0b00000010,
},{
    // 114  0x72  r  Lower case r
    0b00000000,
    0b00000000,
    0b00101100,
    0b00110010,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
},{
    // 115  0x73  s  Lower case s
    0b00000000,
    0b00000000,
    0b00011110,
    0b00100000,
    0b00011100,
    0b00000010,
    0b00111100,
    0b00000000
},{
    // 116  0x74  t  Lower case t
    0b00001000,
    0b00001000,
    0b00111110,
    0b00001000,
    0b00001000,
    0b00001010,
    0b00000100,
    0b00000000
},{
    // 117  0x75  u  Lower case u
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00100110,
    0b00011010,
    0b00000000
},{
    // 118  0x76  v  Lower case v
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00000000
},{
    // 119  0x77  w  Lower case w
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00101010,
    0b00101010,
    0b00010100,
    0b00000000
},{
    // 120  0x78  x  Lower case x
    0b00000000,
    0b00000000,
    0b00100010,
    0b00010100,
    0b00001000,
    0b00010100,
    0b00100010,
    0b00000000
},{
    // 121  0x79  y  Lower case y
    0b00000000,
    0b00000000,
    0b00100010,
    0b00100010,
    0b00011110,
    0b00000010,
    0b00100010,
    0b00011100
},{
    // 122  0x7A  z  Lower case z
    0b00000000,
    0b00000000,
    0b00111110,
    0b00000100,
    0b00001000,
    0b00010000,
    0b00111110,
    0b00000000
},{
    // 123  0x7B  {  Open brace
    0b00000100,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00001000,
    0b00001000,
    0b00000100,
    0b00000000
},{
    // 124  0x7C  |  Pipe
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00000000
},{
    // 125  0x7D  }  Close brace
    0b00010000,
    0b00001000,
    0b00001000,
    0b00000100,
    0b00001000,
    0b00001000,
    0b00010000,
    0b00000000
},{
    // 126  0x7E  ~  Tilde
    0b00010000,
    0b00101010,
    0b00000100,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
},{
    // 127  0x7F     Delete
    0b00001000,
    0b00011100,
    0b00110110,
    0b00100010,
    0b00100010,
    0b00111110,
    0b00000000,
    0b00000000
} };
