;dice2.asm  

;microcontroller dice
;
;  P1.7         P1.3
;
;  P1.6   P1.4  P1.2
;
;  P1.5         P1.1  
;
;      P1.0 = key
;

#include 8051.H
         .org 0000H

main     mov   a,#0FFh   
         mov   P1,a         ;all leds off
         mov   r1,#1        ;first number 
loop     jb    P1.0,loop    ;wait for key   
key      acall play         ;r1=r1+r1
         mov   a,#01h   
         mov   P1,a         ;all leds on
         mov   a,#5
         acall delay
         jnb   P1.0,key

         acall play         ;roll
         mov   a,#10
         acall delay
         acall play
         mov   a,#25        ;slower
         acall delay
         acall play
         mov   a,#50
         acall delay        ;slower
         acall play
         mov   a,#100
         acall delay        ;slower
         acall play
         mov   a,#150
         acall delay        ;slower
         acall play
         mov   a,#200
         acall delay        ;slower
         acall play
         mov   a,#250
         acall delay        ;slower
         acall play
         mov   a,#250
         acall delay        ;last
         acall delay
         acall play         ;stop
         sjmp  loop


play     mov   a,r1         ;r1 = memory 
         inc   a
         mov   r1,a         ;r1=r1+1
         cjne  r1,#7,out    
         mov   r1,#1        ;reset to 1
out      cjne  r1,#6,out5
         mov   a,#00010001b ;output "6"  
         mov   P1,a 
out5     cjne  r1,#5,out4
         mov   a,#01000101b ;output "5"            
         mov   P1,a 
out4     cjne  r1,#4,out3
         mov   a,#01010101b ;output "4"    
         mov   P1,a 
out3     cjne  r1,#3,out2
         mov   a,#01101101b ;output "3"   
         mov   P1,a 
out2     cjne  r1,#2,out1
         mov   a,#11010111b ;output "2"   
         mov   P1,a 
out1     cjne  r1,#1,out0
         mov   a,#11101111b ;output "1"    
         mov   P1,a 
out0     ret  
  

delay    mov   r7,a
delay1   mov   r6,#255
delay2   djnz  r6,delay2
         djnz  r7,delay1
         ret
  
         .end
