unit Flash8252;

interface

uses RSCOM,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    FlashHex: TButton;
    Memo1: TMemo;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Erase: TButton;
    FlashBin: TButton;
    procedure FlashHexClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure EraseClick(Sender: TObject);
    procedure FlashBinClick(Sender: TObject);
  end;

var
  Form1: TForm1;
  COM: Integer = 2;

implementation

{$R *.DFM}

function HexToInt (Hexzahl: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hexzahl[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hexzahl[2])-48;
  if l>9 then l:=l-7;
  Result := 16*h+l;
end;

function ByteToHex (Dat: Integer): String;
var   Hi, Lo: Integer;
      LoHex, HiHex: String;
begin
  Lo := Dat and 15;
  Hi := Dat div 16;
  if Hi > 9 then Hi := Hi + 7;
  HiHex := Chr (48+Hi);
  if Lo > 9 then Lo := Lo + 7;
  LoHex := Chr (48+Lo);
  Result := HiHex + LoHex;
end;

procedure SPIout ( Wert : Byte );
var Stelle, n : Integer;
begin
  Stelle := 128;         {MSB zuerst}
  for n:=1 to 8 do begin
    if ((Wert AND Stelle) > 0) then
      TXD(0)             { Daten an RTS/MOSI  }
      else TXD(1);
    Delay (0.01);        { Verzgerung }
    RTS (0);             { Clock an  (DTR) }
    Stelle := Stelle div 2;
    Delay (0.01);        { Verzgerung }
    RTS (1);             { Clock aus (DTR) }
    Delay (0.01);        { Verzgerung }
  end;
  Delay (0.01);          { Verzgerung }
  TXD (1);
end;

procedure Prog (Adresse:Word; Daten: Byte);
begin
  SPIout (hi(Adresse) * 8 + 2);
  SPIout (lo (Adresse));
  SPIout (Daten);
  Delay (5);     {5ms reicht}
end;

procedure TForm1.FlashHexClick(Sender: TObject);  //Flash
 VAR  f :TextFile;
 Zeile: String;
      r,wert :Byte;
      Anzahl: Byte;
      Adresse, n, i, Code : Word;
begin
   if COM=2 then OpenCOM (pchar ('COM2:9600,N,8,1'));
   if COM=1 then OpenCOM (pchar ('COM1:9600,N,8,1'));
   OpenDialog1.FileName := '*.hex';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
    AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      RTS (1);    //Clock=0;
      Delay (100);
      DTR (1);    //Resest =1;
      Delay(100);
      SPIout ($AC);  //Prog Enable
      SPIout ($53);
      SPIout ($00);
      Memo1.Clear;
      repeat
        Readln(f,Zeile);
        Anzahl := HexToInt (copy(Zeile,2,2));
        Adresse := 256*HexToInt(copy(Zeile,4,2))+HexToInt(copy(Zeile,6,2));
        Memo1.Lines.add ('');
        if Memo1.Lines.Count > 260 then Memo1.Clear;
        n :=  Memo1.Lines.count;
        Memo1.Lines[n] := ByteToHex(Adresse div 256) + ByteToHex(Adresse and 255)+ ' ';
        if Anzahl>0 then begin
          for i := 1 to Anzahl do begin
            code := HexToInt(copy(Zeile,8+2*i,2));
            Prog (Adresse, Code);
            if i = 17 then begin
               Memo1.Lines.add ('     ');
               n:=n+1;
              end;
            Memo1.Lines[n] := Memo1.Lines[n] + ' ' + ByteToHex(Code);
            Adresse := Adresse + 1;
          end;
        end;
        n:=n+1;
      until Anzahl = 0;
      CloseFile(f);
      TXD (0);
      DTR (0);
      RTS (0);
     end;
    end;
    CloseCOM;
  end;


procedure TForm1.FormCreate(Sender: TObject);
begin
 If (OpenCOM (pchar ('COM2:9600,N,8,1')))=0 then begin;
   RadioButton1.Checked := true;
   OpenCOM (pchar ('COM1:9600,N,8,1'));
 end;
 CloseCOM;
 TimeInit;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
  COM := 1;
   If (OpenCOM (pchar ('COM1:9600,N,8,1')))=0 then begin;
   COM := 2;
   memo1.Lines[1] := ('COM1 nicht bereit');
   end else  memo1.Lines[1] := ('COM1 geffnet') ;
   CloseCOM;
 end;


procedure TForm1.RadioButton2Click(Sender: TObject);
begin
  COM := 2;
   If (OpenCOM (pchar ('COM2:9600,N,8,1')))=0 then begin;
   COM := 1;
   memo1.Lines[1] := ('COM1 nicht bereit');
   end else  memo1.Lines[1] := ('COM2 geffnet');
   CloseCOM;
end;

procedure TForm1.EraseClick(Sender: TObject);   //Erase
begin
   if COM=2 then OpenCOM (pchar ('COM2:9600,N,8,1'));
   if COM=1 then OpenCOM (pchar ('COM1:9600,N,8,1'));
      RTS (1);       //Clock=0;
      Delay (100);
      DTR (1);       //Resest =1;
      Delay(100);
      SPIout ($AC);  //Prog Enable
      SPIout ($53);
      SPIout ($00);
      Delay (10);
      SPIout ($AC);  //Erase
      SPIout ($04);
      SPIout ($00);
      Delay (100);
      RTS (0);
      DTR (0);
      TXD (0);
   CloseCOM;
end;

procedure TForm1.FlashBinClick(Sender: TObject);
VAR  f :File of Byte;
 Zeile: String;
      r,wert :Byte;
      Anzahl: Byte;
      Adresse, n, i : Word;
      Code: Byte;
begin
   if COM=2 then OpenCOM (pchar ('COM2:9600,N,8,1'));
   if COM=1 then OpenCOM (pchar ('COM1:9600,N,8,1'));
   OpenDialog1.FileName := '*.bin';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
     AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      DTR (1);    //Clock=0;
      Delay (100);
      TXD (1);    //Resest =1;
      Delay(100);
      SPIout ($AC);  //Prog Enable
      SPIout ($53);
      SPIout ($00);
      Adresse :=0;
      Memo1.clear;
      Memo1.Lines.add ('');
      n :=  Memo1.Lines.count-1;
      Memo1.Lines[n] := '0000 ';
      while not Eof (f) do begin
        Read(f,Code);
        Memo1.Lines[n] := memo1.Lines[n] + ' ' + ByteToHex(Code);
        Prog (Adresse, Code);
        Delay (5);
        Adresse := Adresse + 1;
        If (Adresse mod 16) = 0 then begin
          if Memo1.Lines.Count > 260 then Memo1.Clear;
          Memo1.Lines.add ('');
          n :=  Memo1.Lines.Count -1;
          Memo1.Lines[n] := ByteToHex(Adresse div 256) + ByteToHex(Adresse and 255)+ ' ';
        end;
      end;
      CloseFile(f);
      TXD (0);
      DTR (0);
      RTS (0);
     end;
    end;
    CloseCOM;
end;

end.
