;Max186d.asm
;2 chan scope, 
;10 kS/s

#include 8051.h
OEA  .equ   7F9Ch
OEB  .equ   7F9Dh
OEC  .equ   7F9Eh
PINSA .equ  7F99h
PINSB .equ  7F9Ah
PINSC .equ  7F9Bh
OUTA .equ   7F96h
OUTB .equ   7F97h
OUTC .equ   7F98h
DPS  .equ   86h

     lcall initMAX186
     mov DPTR,#01FEh ;0: 1 chan, 1: 2 chan 
     movx a,@DPTR
     jz  Ch1

Ch2  mov DPTR,#0200h
     mov r6,#4
C1   mov r7,#0
C2   mov a,#1      ;clear/fill RAM
     movx @DPTR,A
     inc DPTR
     djnz r7,C2
     djnz r6,C1
     mov DPTR,#1FFh
     movx a,@DPTR
     jz  Go2
     mov r7,a      ;#127
Tr1  mov a,#142	;Ch0
     lcall RdAD
     mov a,R3
     subb a,R7 
     jnc  Tr1
Tr2  mov a,#142	;Ch0
     lcall RdAD
     mov a,R3
     subb a,R7 
     jc  Tr2

Go2  mov DPTR,#0200h
     mov r6,#10
L1   mov r7,#0
L2   mov a,#142	;Ch0
     inc DPS
     lcall RdAD
     inc DPS
     mov a,R3	;Highbyte
     movx @DPTR,A
     inc DPTR

     mov a,#206	;Ch1
     inc DPS
     lcall RdAD
     inc DPS
     mov a,R3	;Highbyte
     movx @DPTR,A
     inc DPTR
     djnz r7,L2
     djnz r6,L1
Loop sjmp Loop



Ch1  mov DPTR,#0200h
     mov r6,#4
C11  mov r7,#0
C12  mov a,#1      ;clear/fill RAM
     movx @DPTR,A
     inc DPTR
     djnz r7,C12
     djnz r6,C11

     mov DPTR,#1FFh
     movx a,@DPTR
     jz  Go1
     mov r7,a      ;#127
Tr11 mov a,#142	;Ch0
     lcall RdAD
     mov a,R3
     subb a,R7 
     jnc  Tr11
Tr12 mov a,#142	;Ch0
     lcall RdAD
     mov a,R3
     subb a,R7 
     jc  Tr12

Go1  mov DPTR,#0200h
     mov r6,#10
L11  mov r7,#0
L12  mov a,#142	;Ch0
     inc DPS
     lcall RdAD
     inc DPS
     mov a,R3	;Highbyte
     movx @DPTR,A
     inc DPTR
     djnz r7,L12
     djnz r6,L11
Loop1 sjmp Loop1


initMAX186
     mov DPTR,#OEB
     mov a,#7    ;PortB0...2 Outputs
     movx @DPTR,a
     mov DPTR,#OUTB
     mov a,#2    ;/CS = 1
     movx @DPTR,a
     ret

Delay		;delay [a] times 
     mov R1,#255
S0   djnz R1,S0
     dec a
     jnz Delay
     ret

RdAD		;Control byte in A
     mov R3,a	;save Control Byte
     mov DPTR,#OUTB
     mov a,0	;/CS = 0
     movx @DPTR,a
;*** Transfer control byte ***
     mov A,#0	
     mov R2,#8 
S1   Xch a,R3     	;Control-Byte
     jnb ACC.7,S2	;Bit7 = 1?
     mov R3,#4		;Din = 1
S2   xch a,R3
     movx @DPTR,a
     inc a		;SCLK = 1
     movx @DPTR,a
     dec a
     movx @DPTR,a  	;SCLK = 0
     mov a,#0      	;Din =0
     xch a,R3
     rl  a  		;next Bit
     xch a,R3
     djnz R2,S1
;*** Wait for conversion complete ***
     mov R2,#30
S3   djnz R2,S3 	;delay > 10 s
;*** Read highbyte to R3 ***
     mov R3,#0 		;Highbyte > R3
     mov R2,#8
S4   xch a,R3
     rl  a
     xch a,R3
     mov DPTR,#OUTB
     mov a,#1		;SCLK = 1
     movx @DPTR,a 
     mov a,#0		;SCLK = 0
     movx @DPTR,a 
     mov DPTR,#PINSB 
     movx a,@DPTR
     jnb ACC.4,S5
     inc R3
S5   djnz R2,S4  
     mov DPTR,#OUTB
     mov a,#2		;/CS = 1
     movx @DPTR,a 
     ret

.End
