unit Scope1;

interface

uses EZUSB,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Messung: TButton;
    ScrollBar1: TScrollBar;
    Auto: TButton;
    Timer1: TTimer;
    TriggerA: TButton;
    TriggerOff: TButton;
    Chan1: TButton;
    Chan12: TButton;
    Chan1minus2: TButton;
    XY: TButton;
    procedure MessungClick(Sender: TObject);
    procedure Messung2Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AutoClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure AutoOffClick(Sender: TObject);
    procedure TriggerOffClick(Sender: TObject);
    procedure TriggerAClick(Sender: TObject);
    procedure Chan12Click(Sender: TObject);
    procedure Chan1minus2Click(Sender: TObject);
    procedure Chan1Click(Sender: TObject);
    procedure XYClick(Sender: TObject);
  end;

var
  Form1: TForm1;
  Buffer : Array [0..8000] of Byte;
  Mode, Trigger: Integer;
  t : integer;
  StartTime: Int64;
  TimeUnit: Real = 0.000838;


implementation

{$R *.DFM}

procedure TIMEINIT();
var f: Int64;
begin
  QueryPerformanceFrequency(f);
  TimeUnit := 1000 / f;
  QueryPerformanceCounter(StartTime)
end;

function TIMEREAD(): Real;
var t: Int64;
begin
  QueryPerformanceCounter(t);
  TIMEREAD := TimeUnit*(t - StartTime) ;
end;

procedure DELAY(DelayTime: Real);
var TimeStart: real;
begin
  TimeStart := TIMEREAD;
  while TIMEREAD < (TimeStart + DelayTime) do;
end;


procedure DiagramInit;
var n: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
  Pen.Color:=ClBlack;
  Brush.Color:=ClWhite;
  Rectangle(30,0,543,257);
  Pen.Color:=ClLtGray;
  for n:= 1 to 8 do begin
      MoveTo(31,256-n*31);
      Lineto (543,256-n*31);
  end;
  Brush.Color:=ClLtGray;
  for n:= 0 to 4 do begin
    TextOut(10,250-n*62,FloatToStr(n)+' V');
  end;
  for n:= 1 to 10 do begin
      MoveTo(30+50*n,254);
      Lineto (30+50*n,0)
  end;
  for n:= 1 to 10 do begin
    TextOut(15+50*n,260,FloatToStr(n*5)+'ms');
  end;
  end;
end;

procedure PlotChan1;
var i: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
    Pen.Color:=ClBlack;
    MoveTo (31,256-Buffer[0]);
    for i := 1 to 511 do
      LineTo (31+i ,256-Buffer[i]);
  end;
end;

procedure PlotChan12;
var i: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
    Pen.Color:=ClBlack;
    MoveTo (31,256-Buffer[0]);
    for i := 1 to 255 do
      LineTo (31+i*2 ,256-Buffer[2*i]);
    MoveTo (31,256-Buffer[1]);
    for i := 1 to 255 do
      LineTo (31+i*2 ,256-Buffer[2*i +1]);
  end;
end;

procedure PlotChan1minus2;
var i,y: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
    Pen.Color:=ClBlack;
    MoveTo (31,256-Buffer[0]);
    for i := 1 to 511 do begin
      y := 128-Buffer[2*i] +  Buffer [2*i+1];
      if y<0 then y :=0;
      if y>255 then y := 255;
      LineTo (31+i ,y);
    end;  
  end;
end;

procedure PlotXY;
var i: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
    Pen.Color:=ClBlack;
    MoveTo (31+2*Buffer[1],256-Buffer[0]);
    for i := 1 to 511 do
      LineTo (31+2*Buffer[2*i+1] ,256-Buffer[2*i]);
  end;
end;


procedure TForm1.MessungClick(Sender: TObject);
var n,i: Word;
begin
  Timer1.Enabled := false;
  ProgReset;
  ProgStart;
  delay (100);
  ProgReset;
  for n:= 0 to 3 do begin
    ReadRamBytes ((512+n*1024),1024);
    for i:= 0 to 1023 do Buffer[n*1024+i] := InBuffer[i];
  end;
  DiagramInit;
  Case Mode of
  1: PlotChan1;
  2: PlotChan12;
  3: PlotChan1minus2;
  4: PlotXY;
  end;
end;


procedure TForm1.Messung2Click(Sender: TObject);
begin
  DiagramInit;
end;




procedure TForm1.ScrollBar1Change(Sender: TObject);
var level: Integer;
begin
  level := 255-Scrollbar1.Position;
  if level < 1 then level := 1;
  WrRAM ($01FF,level);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ProgReset;
  DownLoadBin ('scope.bin');
  WrRAM ($01FE,0); //1 Chan
  WrRAM ($01FF,0); //Trigger = Off
  mode := 1;
  timer1.enabled := true;
end;

procedure TForm1.AutoClick(Sender: TObject);
begin
  Timer1.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var n,i: Word;
begin;
  ProgReset;
  ProgStart;
  delay (300);
  ProgReset;
  for n:= 0 to 3 do begin
    ReadRamBytes ((512+n*1024),1024);
    for i:= 0 to 1023 do Buffer[n*1024+i] := InBuffer[i];
  end;
  DiagramInit;
  Case Mode of
  1: PlotChan1;
  2: PlotChan12;
  3: PlotChan1minus2;
  4: PlotXY;
  end;
end;

procedure TForm1.AutoOffClick(Sender: TObject);
begin
  Timer1.Enabled := false;
end;

procedure TForm1.TriggerOffClick(Sender: TObject);
begin
  ProgReset;
  WrRAM ($01FF,0);
  Trigger := 0;
  ScrollBar1.Visible := false;
end;

procedure TForm1.TriggerAClick(Sender: TObject);
var Level: integer;
begin
  ProgReset;
  level := 255-Scrollbar1.Position;
  if Level < 1 then level := 1;
  WrRAM ($01FF,level);
  Trigger := 1;
  ScrollBar1.Visible := true;
end;

procedure TForm1.Chan12Click(Sender: TObject);
begin
  WrRAM ($01FE,1); //2 Chan
  mode := 2;
end;

procedure TForm1.Chan1minus2Click(Sender: TObject);
begin
  WrRAM ($01FE,1); //2 Chan
  mode := 3;
end;

procedure TForm1.Chan1Click(Sender: TObject);
begin
  WrRAM ($01FE,0); //1 Chan
  mode := 1;
end;

procedure TForm1.XYClick(Sender: TObject);
begin
  WrRAM ($01FE,1); //2 Chan
  mode := 4;
end;





end.

