;TLC549.asm  port outputs
;Output to MAX512

#include 8051.H
SPCR .equ 0D5h ; SPI control register
SPDR .equ 86h ; SPI data register
SPSR .equ 0AAh ; SPI status register
SPIF .equ 10000000b ; interrupt flag

CS   .equ P1.4 ; 
MOSI .equ P1.5 ; SPI
MISO .equ P1.6 ; SPI
SCK  .equ P1.7 ; SPI

         .org 0000H

main     mov   a,#00  
         mov   SPCR,#01010100b ; CPHA=1
next     clr   CS       ;chip select 
         mov   r1,a     ;save A
         mov   a,#7
         lcall SPI      ;get ADC data
         lcall SPI      ;put DAC data
         setb  CS       ;end of chip select
         mov   a,r1     ;restore A
         mov   r3,#6  ;
loop     djnz  r3,loop  ;20 s delay
         inc   a        
         sjmp  next     

SPI      mov   SPDR,a   ;output
Busy     mov   a,SPSR   ;status
         anl   a,#SPIF  ;busy?
         jz    Busy     
         mov   a,SPDR   ;read
         ret
         .end

