unit RSLINES;

interface
uses Windows;
var  PortHandle: THandle;

function OPENCOM (OpenString: Pchar): Integer; stdcall;
procedure CLOSECOM();
procedure DTR(State:integer);
procedure RTS(State:integer);
procedure TXD(State:integer);
function CTS():Integer;
function DSR():Integer;
function RI():Integer;
function DCD():Integer;
procedure TIMEINIT();
function TIMEREAD(): Real;
procedure DELAY(DelayTime: Real);
procedure REALTIME();
procedure NORMALTIME();

implementation

var  StartTime: Int64;
     TimeUnit: Real = 0.000838;


function OPENCOM (OpenString: pchar): Integer;
var PortStr, Parameter :String;
    DCB: TDCB;
begin
   Result := 0;
   if PortHandle > 0 then CloseHandle(PortHandle);
   Parameter := OpenString;
   PortStr := copy (Parameter,1,4);
   PortHandle:=CreateFile(PChar(PortStr),GENERIC_READ or GENERIC_WRITE,0,NIL,OPEN_EXISTING,0,0);
   GetCommState(PortHandle,DCB);
   BuildCommDCB(PChar(Parameter),dcb);
   DCB.Flags := 1;
   if SetCommState(PortHandle,DCB)then Result := 1;
end;

procedure CLOSECOM();
begin
    CloseHandle(PortHandle);
    PortHandle:= 0;
end;

procedure DTR(State:integer);
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRDTR)
 else EscapeCommFunction(PortHandle,SETDTR);
end;

procedure RTS(State:integer);
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRRTS)
 else EscapeCommFunction(PortHandle,SETRTS);
end;

procedure TXD(State:integer);
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRBREAK)
 else EscapeCommFunction(PortHandle,SETBREAK);
end;

function CTS():Integer;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_CTS_ON)=0 then result:=0 else result:=1;
end;

function DSR():Integer;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_DSR_ON)=0 then result:=0 else result:=1;
end;

function RI():Integer;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_RING_ON)=0 then result:=0 else result:=1;
end;

function DCD():Integer;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_RLSD_ON)=0 then result:=0 else result:=1;
end;

function INPUTS():Integer;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     INPUTS := (mask div 16) and 15;
end;

procedure TIMEINIT();
var f: Int64;
begin
  QueryPerformanceFrequency(f);
  TimeUnit := 1000 / f;
  QueryPerformanceCounter(StartTime)
end;

function TIMEREAD(): Real;
var t: Int64;
begin
  QueryPerformanceCounter(t);
  TIMEREAD := TimeUnit*(t - StartTime) ;
end;

procedure DELAY(DelayTime: Real);
var TimeStart: real;
begin
  TimeStart := TIMEREAD;
  while TIMEREAD < (TimeStart + DelayTime) do;
end;

procedure REALTIME();
begin
 SetPriorityClass (GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
end;

procedure NORMALTIME();
begin
  SetPriorityClass (GetCurrentProcess(), NORMAL_PRIORITY_CLASS);
end;

begin
end.

