Attribute VB_Name = "Module1"
'Escape Functions
Const SETXOFF = 1 '  Simulate XOFF received
Const SETXON = 2 '  Simulate XON received
Const SETRTS = 3 '  Set RTS high
Const CLRRTS = 4 '  Set RTS low
Const SETDTR = 5 '  Set DTR high
Const CLRDTR = 6 '  Set DTR low
Const RESETDEV = 7 '  Reset device if possible
Const SETBREAK = 8 'Set the device break line
Const CLRBREAK = 9 ' Clear the device break line

Const GENERIC_READ = &H80000000
Const GENERIC_WRITE = &H40000000
Const OPEN_EXISTING = 3

Declare Function CreateFile Lib "kernel32" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal NOlpSecurityAttributes As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Declare Function EscapeCommFunction Lib "kernel32" (ByVal nCid As Long, ByVal nFunc As Long) As Long
Declare Function GetCommModemStatus Lib "kernel32" (ByVal hFile As Long, lpModemStat As Long) As Long
Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As LARGE_INTEGER) As Long
Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As LARGE_INTEGER) As Long
Declare Function GetCurrentProcess Lib "kernel32" () As Long
Declare Function SetPriorityClass Lib "kernel32" (ByVal hProcess As Long, ByVal dwPriorityClass As Long) As Long

Type LARGE_INTEGER
    lowpart As Long
    highpart As Long
End Type

Dim nCid As Long
Dim TimeUnit As Double
Dim StartTimeLow As Long
Dim StartTimeHigh As Long


Function OPENCOM(ByVal lpDef As String) As Integer
  nCid = CreateFile(Left(lpDef, 4), GENERIC_READ Or GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0)
  If nCid > 0 Then OPENCOM = nCid Else OPENCOM = 0
End Function

 
Sub CLOSECOM()
   x = CloseHandle(nCid)
End Sub
Sub DTR(Status As Integer)
  If Status = 1 Then EscapeCommFunction nCid, SETDTR Else: EscapeCommFunction nCid, CLRDTR
End Sub
Sub RTS(Status As Integer)
  If Status = 1 Then EscapeCommFunction nCid, SETRTS Else: EscapeCommFunction nCid, CLRRTS
End Sub
Sub TXD(Status As Integer)
  If Status = 1 Then EscapeCommFunction nCid, SETBREAK Else: EscapeCommFunction nCid, CLRBREAK
End Sub

Function TimeRead() As Double
  Dim t As LARGE_INTEGER
  TimeUnit = 0.000838096515
  x = QueryPerformanceCounter(t)
  TimeRead = (t.highpart * 4294967296# + t.lowpart - StartTimeHigh * 4294967296# - StartTimeLow) * TimeUnit
End Function
Sub Delay(DelayTime As Double)
  TimeStart = TimeRead
  While TimeRead < (TimeStart + DelayTime)
  Wend
End Sub
