unit ClockI2C;

interface

uses RSLINES,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    FlashBin: TButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    Edit1: TEdit;
    FtoRAM: TButton;
    ScrollBar1: TScrollBar;
    Freq: TLabel;
    RAMbin: TButton;
    ProgressBar1: TProgressBar;
    LabelFmin: TLabel;
    LabelFmax: TLabel;
    CMD1_4: TButton;
    CMD2_8: TButton;
    Cmd4_16: TButton;
    Cmd10_40: TButton;
    Cmd25_100: TButton;
    FtoEEPROM: TButton;
    procedure FormCreate(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure FlashBinClick(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure FtoRAMClick(Sender: TObject);
    procedure CMD1_4Click(Sender: TObject);
    procedure CMD2_8Click(Sender: TObject);
    procedure Cmd4_16Click(Sender: TObject);
    procedure Cmd10_40Click(Sender: TObject);
    procedure RAMbinClick(Sender: TObject);
    procedure FtoEEPROMClick(Sender: TObject);
    procedure Cmd25_100Click(Sender: TObject);
  end;

var
  Form1: TForm1;
  COM: Integer = 2;
   Codearray : array [0..5000] of byte;
   Fehler: Boolean;
  P,Q,Div1N: Integer;
 var R40, R41, R42 : Integer;
   P0: Integer;
    IICadr,n: Integer;
    Step: Real;

implementation

{$R *.DFM}

procedure I2C_Init;
begin
  RTS(1); DTR(1);          { SCL=1, SDA=1 }
end;

procedure Start;
begin
  DTR(0);          { SDA=0 }
  RTS(0);          { SCL=0 }
end;

procedure Stop;
begin
  RTS(0); DTR(0);  { SCL=0, SDA=0 }
  RTS(1);          { SCL=1 }
  DTR(1);          { SDA=1 }
end;

procedure Acknowledge;
begin
  RTS(0); DTR(0);  { SCL=0, SDA=0 }
  RTS(1);          { SCL=1 }
  Delay  (0.10);    { Warteschleife }
  RTS(0);          { SCL=0 }
end;

procedure KeinAcknowledge;
begin
  RTS(0); DTR(1);  { SCL=0, SDA=1 }
  RTS(1);          { SCL=1 }
  Delay  (0.10);    { Warteschleife }
  RTS(0);          { SCL=0 }
end;

Function Ausgeben (Wert : Byte): Boolean;
var Bitwert, n: Byte;
begin
  Ausgeben := true;
  Bitwert := 128;
  for n:= 1 to 8 do begin
    if (Wert and Bitwert) = Bitwert then DTR(1)
     else DTR(0);   { SDA setzen }
    RTS(1);         { SCL=1 }
    Delay  (0.10);   { Warteschleife }
    RTS(0);         { SCL=0 }
    Bitwert := Bitwert div 2;
  end;
  DTR(1);           { SDA=1 }
  RTS(1);           { SCL=1, SDA lesen }
  Delay  (0.10);     { Warteschleife }
  if CTS = 1 then Ausgeben := False;
  RTS(0);           { SCL=0 }
end;

function Einlesen : Byte;
var Bitwert, Wert, n: Byte;
begin
  RTS(0); DTR(1);   { SDA=1, SCL=0 }
  Bitwert := 128;
  Wert := 0;
  for n:= 1 to 8 do begin
    RTS(1);         { SCL=1, SDA lesen }
    Delay  (0.10);   { Warteschleife }
    If CTS = 1 then Wert := Wert + Bitwert;
    RTS(0);         { SCL=0 }
    Bitwert := Bitwert div 2;
  end;
  Einlesen := Wert;
end;





function HexToInt (Hexzahl: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hexzahl[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hexzahl[2])-48;
  if l>9 then l:=l-7;
  Result := 16*h+l;
end;

function ByteToHex (Dat: Integer): String;
var   Hi, Lo: Integer;
      LoHex, HiHex: String;
begin
  Lo := Dat and 15;
  Hi := Dat div 16;
  if Hi > 9 then Hi := Hi + 7;
  HiHex := Chr (48+Hi);
  if Lo > 9 then Lo := Lo + 7;
  LoHex := Chr (48+Lo);
  Result := HiHex + LoHex;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
 If (OpenCOM (pchar ('COM1:9600,N,8,1')))=0 then begin
   RadioButton1.Checked := true;
   Edit1.text := 'COM'+IntToStr (COM) + ' open'
 end;
  Div1N:=100;
  LabelFmin.Caption := '1 MHz';
  LabelFmax.Caption := '4 MHz';
  Step := 2.5;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ 'kHz';
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
   CloseCOM;
   COM := 1;
   If (OpenCOM (pchar ('COM1:9600,N,8,1')))=0 then begin;
   Edit1.text := ('COM1 error');
   end else  Edit1.text := ('COM1 open') ;
end;


procedure TForm1.RadioButton2Click(Sender: TObject);
begin
   CloseCOM;
   COM := 2;
   If (OpenCOM (pchar ('COM2:9600,N,8,1')))=0 then begin;
   Edit1.text := ('COM2 error');
   end else  Edit1.text := ('COM2 open') ;
end;

procedure TForm1.FlashBinClick(Sender: TObject);
VAR  f :File of Byte;
     r,wert :Byte;
     Anzahl: Byte;
     Adresse, m, n, i : Word;
     MaxAdr: Word;
     Code: Byte;
begin
   OpenDialog1.FileName := '*.bin';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
     AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Adresse :=0;
      while (not Eof (f)) and (Adresse < 256) do begin
        Read(f,Code);
        Codearray[Adresse] := Code;
        Adresse := Adresse + 1;
      end;
      CloseFile(f);
  I2C_Init;
  Delay (1);
  IICadr:= 208;
  for n:= 0 to 15 do begin
  Start;
  Fehler:=Not(Ausgeben (IICadr)); {Adr 210, RAM, Ack?}
  if Fehler then  Edit1.text := 'I2C-Error'; //('Fehler!');
  if (not Fehler) then begin;
     Ausgeben (n*16);
     for m:= 0 to 15 do begin
       Ausgeben (CodeArray[n*16+m]);
     end;
     Stop;
     ProgressBar1.Position := n*16+15;
     Delay (200);
     ProgressBar1.Position := 0;
   end;
  end;
 end;
end;
end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
   CloseCOM;
   COM := 3;
   If (OpenCOM (pchar ('COM3:9600,N,8,1')))=0 then begin;
   Edit1.text := ('COM3 error');
   end else  Edit1.text := ('COM3 open') ;
end;

procedure TForm1.RadioButton4Click(Sender: TObject);
begin
   CloseCOM;
   COM := 4;
   If (OpenCOM (pchar ('COM4:9600,N,8,1')))=0 then begin;
   Edit1.text := ('COM4 error');
   end else  Edit1.text := ('COM4 open') ;
end;




procedure TForm1.Button2Click(Sender: TObject);
var n: Integer;
begin
OpenCOM (pchar ('COM2:9600,N,8,1'));
  I2C_Init;
  Delay (1);
  for N:= 0 to 200 do begin
    Start;
   if(Ausgeben (n)) then edit1.text := Edit1.Text + IntToStr (n) + ' ';
   ; {Adr 210, RAM, Ack?}
   Stop;
  delay (2);
  end;

end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  P :=Scrollbar1.position;
  Freq.caption :=  FloatToStr (P*Step)+ ' kHz';
end;

procedure TForm1.FtoRAMClick(Sender: TObject);
var Pump: Integer;
begin
  IICadr:=210;
  Pump := 1;
  If P>479 then Pump := 2;
  If P>639 then Pump := 3;
  If P>799 then Pump := 4;
  P0:= P mod 2;
  R40 := (P div 2 -4 ) div 256 + 4 * Pump + 192;
  R41 := (P div 2 -4) and 255;
  R42 := 38+128*P0;      //q+2=48, 12 MHz / 48 = 250 kHz
  //Label2.caption :=IntToStr (P) + ' ' +IntToStr (R40) + ' '+   IntToStr (R41) + ' '+ IntToStr (R42) + ' ';
  I2C_Init;
  Delay (1);
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (64);       //Adr 40 hex
  Ausgeben (R40);
  Ausgeben (R41);
  Ausgeben (R42);
  Stop;
  Delay (10);
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (12);       //Adr 0C hex
  Ausgeben (Div1N);    //DIV1N=50
  Stop;
end;


procedure TForm1.CMD1_4Click(Sender: TObject);
begin
  Div1N:=100;
  LabelFmin.Caption := '1 MHz';
  LabelFmax.Caption := '4 MHz';
  Step := 2.5;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ ' kHz';
end;

procedure TForm1.CMD2_8Click(Sender: TObject);
begin
  Div1N:=50;
  LabelFmin.Caption := '2 MHz';
  LabelFmax.Caption := '8 MHz';
  Step := 5;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ ' kHz';
end;

procedure TForm1.Cmd4_16Click(Sender: TObject);
begin
  Div1N:=25;
  LabelFmin.Caption := '4 MHz';
  LabelFmax.Caption := '16 MHz';
  Step := 10;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ ' kHz';
end;

procedure TForm1.Cmd10_40Click(Sender: TObject);
begin
  Div1N:=10;
  LabelFmin.Caption := '10 MHz';
  LabelFmax.Caption := '40 MHz';
  Step := 25;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ ' kHz';
end;

procedure TForm1.RAMbinClick(Sender: TObject);
VAR  f :File of Byte;
     r,wert :Byte;
     Anzahl: Byte;
     Adresse, m, n, i : Word;
     MaxAdr: Word;
     Code: Byte;
begin
   OpenDialog1.FileName := '*.bin';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
     AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Adresse :=0;
      while (not Eof (f)) and (Adresse < 256) do begin
        Read(f,Code);
        Codearray[Adresse] := Code;
        Adresse := Adresse + 1;
      end;
      CloseFile(f);
  I2C_Init;
  Delay (1);
  IICadr:= 210;
  for n:= 0 to 15 do begin
  Start;
  Fehler:=Not(Ausgeben (IICadr)); {Adr 210, RAM, Ack?}
  if Fehler then  Edit1.text := 'I2C-Error'; //('Fehler!');
  if (not Fehler) then begin;
     Ausgeben (n*16);
     for m:= 0 to 15 do begin
       Ausgeben (CodeArray[n*16+m]);
     end;
     Stop;
     ProgressBar1.Position := n*16+15;
     Delay (200);
     ProgressBar1.Position := 0;
   end;
  end;
 end;
end;
end;


procedure TForm1.FtoEEPROMClick(Sender: TObject);
var Pump: Integer;
begin
  IICadr:=208;
  Pump := 1;
  If P>479 then Pump := 2;
  If P>639 then Pump := 3;
  If P>799 then Pump := 4;
  P0:= P mod 2;
  R40 := (P div 2 -4 ) div 256 + 4 * Pump + 192;
  R41 := (P div 2 -4) and 255;
  R42 := 38+128*P0;      //q+2=48, 12 MHz / 48 = 250 kHz
  //Label2.caption :=IntToStr (P) + ' ' +IntToStr (R40) + ' '+   IntToStr (R41) + ' '+ IntToStr (R42) + ' ';
  I2C_Init;
  Delay (1);
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (64);       //Adr 40 hex
  Ausgeben (R40);
  Ausgeben (R41);
  Ausgeben (R42);
  Stop;
  delay(200);
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (12);       //Adr 0C hex
  Ausgeben (Div1N);    //DIV1N=50
  Stop;
end;



procedure TForm1.Cmd25_100Click(Sender: TObject);
begin
  Div1N:=4;
  LabelFmin.Caption := '25 MHz';
  LabelFmax.Caption := '100 MHz';
  Step := 62.5;
  Freq.caption :=  FloatToStr (Scrollbar1.position*Step)+ ' kHz';
end;
end.
