;RS232, Empfangen und Senden mit 9600 Baus bei 1,2 MHz

	.include "tn13def.inc"

    .def   A      = r16
    .def   Delay  = r17
    .def   Count  = r18
	.def   Kom    = r19
    .def   B      = r20
    .def   Count2  = r21
	.def	Xlow	=r26
	.def	Xhigh	=r27



	;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2
	.equ   PWM    = 0


        rjmp   Anfang
Anfang:
        sbi    ddrb,TXD	;Datenrichtung TXD
        sbi    ddrb,PWM	;Datenrichtung PWM-Ausgang
		rcall  AdcInit


Schleife:
        rcall  RdCOM
Oszi:	ldi	Xlow,96
	ldi	Xhigh,0
	ldi	Count2,61
O100:	rcall	ADCrd
	st	X+,A
	dec	Count2
	brne	O100		;101 mal

    ldi	Xlow,96
	ldi	Xhigh,0
	ldi	Count2,61
O101:	
	ld	A, X+
	rcall WrCOM
	dec	Count2
	brne	O101		;101 mal


k100:
        rjmp   Schleife



	
ADCrd:	
    ldi A, 34 ; addi A,32  ;ADLAR, left adjust
	out	ADMUX,A
	sbi	ADCSRA,ADSC
ADrdy:	sbic	ADCSRA,ADSC   
	rjmp	ADrdy
	sbi	ADCSRA,ADSC
ADrdyb:	sbic	ADCSRA,ADSC   
	rjmp	ADrdyb
	;in	A,ADCL
	in	A,ADCH
	ret

	
AdcInit: 
	ldi	A,3
	out	ADCSRA,A	
	sbi	ADCSRA,ADEN
	ret 




RdCOM:	sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        ldi   Delay,58  
D1:     dec   Delay
        brne  D1
        ldi   A,0
        ldi   Count,8
L1:     lsr   A
        sbic  pinb,RXD
        ori   A,128
        ldi   Delay, 38  
D2:     dec   Delay
        brne  D2
        dec   Count
        brne  L1
        ldi   Delay, 38
D3:     dec   Delay
        brne  D3
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        ldi   Delay,38 
D4:     dec   Delay
        brne  D4
        ldi   Count,8
L2:     sbrc  A,0
        rjmp  OFF
        rjmp  ONt
ONt:	sbi   portb,TXD
        rjmp  BitD
OFF:	cbi   portb,TXD
        rjmp  BitD
BitD:	ldi   Delay,38  
D5:     dec   Delay
        brne  D5
        lsr   A
        dec   Count
        brne  L2
        cbi   PORTB,TXD
        ldi   Delay,38  
        ldi   Delay,38    ;2 Stopbits
D6:     dec   Delay
        brne  D6
        ret
