;Regler2.asm, Zweipunktregler mit Hyterese

    .include "tn13def.inc"

    .def   A      = r16
    .def   B      = r17
    .def   Delay  = r18
    .def   Count  = r19

    ;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2


      rjmp Anfang
Anfang:
      sbi    ddrb,3   ;Datenrichtung PB4
      rcall  AdcInit 
Schleife:
      ldi    A,2      ;ADC2 an PB4
      rcall  RdADC 
      ldi    B,20     ;untere Schwelle
      cp     A,B
      brlo   PB3ein
      ldi    B,40     ;obere Schwelle
      cp     A,B
      brsh   PB3aus
      rjmp   Schleife
PB3aus:
      cbi    portb,3
      rjmp   Schleife
PB3ein:
      sbi    portb,3
      rjmp   Schleife

AdcInit: 
      ldi   A,3         ;Clock / 4 
      out   ADCSRA,A	
      sbi   ADCSRA,ADEN ;AD einschalten 
      ret

RdADC:
      out   ADMUX,A
      sbi   ADMUX,ADLAR   ;Left adjust
      sbi   ADCSRA,ADSC   ;Wandlung starten
ADrdy:
      sbic  ADCSRA,ADSC   
      rjmp  ADrdy
      sbi   ADCSRA,ADSC
ADrdyb:
      sbic  ADCSRA,ADSC   
      rjmp  ADrdyb
      in    A,ADCH
      ret
