;RAM, Lesen und Schreiben von 64 Bytes

	.include "tn13def.inc"

    .def   A      = r16
    .def   Delay  = r17
    .def   Count  = r18
    .def   Kom    = r19
    .def   B      = r20
    .def   Count2 = r21

    ;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2


        rjmp   Anfang
Anfang:
        sbi    ddrb,TXD	;Datenrichtung TXD


Schleife:
        rcall  RdCOM
        ldi    XL,96
        ldi    XH,0
        ldi    Count2,64
Lesen:	
        ld     A,X+
        rcall  WrCOM
        dec    Count2
        brne   Lesen     ;64 mal

        ldi    XL,96
        ldi    XH,0
        ldi    Count2,64
Schreiben:
        mov    A,XL
        st     X+,A
        dec    Count2
        brne   Schreiben ;64 mal
        rjmp   Schleife 
 
RdCOM:  sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        ldi   Delay,58  
D1:     dec   Delay
        brne  D1
        ldi   A,0
        ldi   Count,8
L1:     lsr   A
        sbic  pinb,RXD
        ori   A,128
        ldi   Delay, 38  
D2:     dec   Delay
        brne  D2
        dec   Count
        brne  L1
        ldi   Delay, 38
D3:     dec   Delay
        brne  D3
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        ldi   Delay,38 
D4:     dec   Delay
        brne  D4
        ldi   Count,8
L2:     sbrc  A,0
        rjmp  OFF
        rjmp  ON
ON:     sbi   portb,TXD
        rjmp  BitD
OFF:    cbi   portb,TXD
        rjmp  BitD
BitD:   ldi   Delay,38  
D5:     dec   Delay
        brne  D5
        lsr   A
        dec   Count
        brne  L2
        cbi   PORTB,TXD
        ldi   Delay,38   
D6:     dec   Delay
        brne  D6
        ret

