;EEPROM, 60 Bytes lesen und speichern 

	.include "tn13def.inc"

    .def   A      = r16
    .def   Delay  = r17
    .def   Count  = r18
    .def   EEadr  = r19
    .def   EEmode = r20

	;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2


        rjmp Anfang
Anfang:
        sbi    ddrb,TXD	;Datenrichtung TXD
		ldi    EEadr,0
Schleife1:
        rcall  RdEE
		rcall  WrCOM
		inc    EEadr
		cpi    EEadr,60
		brlo   Schleife1
		ldi    EEadr,0
Schleife2:
        rcall  RdCOM
		rcall  WrEE
		inc    EEadr
		cpi    EEadr,60
		brlo   Schleife2
Ende:   rjmp   Ende



RdCOM:  sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        ldi   Delay,58  
D1:     dec   Delay
        brne  D1
        ldi   A,0
        ldi   Count,8
L1:     lsr   A
        sbic  pinb,RXD
        ori   A,128
        ldi   Delay, 38  
D2:     dec   Delay
        brne  D2
        dec   Count
        brne  L1
        ldi   Delay, 38
D3:     dec   Delay
        brne  D3
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        ldi   Delay,38 
D4:     dec   Delay
        brne  D4
        ldi   Count,8
L2:     sbrc  A,0
        rjmp  OFF
        rjmp  ON
ON:     sbi   portb,TXD
        rjmp  BitD
OFF:    cbi   portb,TXD
        rjmp  BitD
BitD:   ldi   Delay,38  
D5:     dec   Delay
        brne  D5
        lsr   A
        dec   Count
        brne  L2
        cbi   PORTB,TXD
        ldi   Delay,38  
D6:     dec   Delay
        brne  D6
        ret



RdEE:   sbic  EECR,EEWE	
        rjmp  RdEE
        out   EEAR,EEadr
        sbi   EECR,EERE
        in    A,EEDR
        ret

WrEE:   sbic  EECR,EEWE
        rjmp  WrEE
        ldi   EEmode,0
        out   EECR,EEmode	
        out   EEARL,EEadr
        out   EEDR,A
        sbi   EECR,EEMPE	
        sbi   EECR,EEPE	
        ret

