;Alarm.asm, Optissche Alarmanlage
    .include "tn13def.inc"

    .def   A      = r16
    .def   B      = r17
    .def   Delay  = r18
    .def   Count  = r19

    ;Port B
    .equ   TXD    = 1
    .equ   RXD    = 2


      rjmp Anfang
Anfang:
      sbi    ddrb,3   ;Datenrichtung PB4
      sbi    ddrb,TXD   
      rcall  AdcInit 
      ldi    A,2      ;ADC2 an PB4
      rcall  RdADC 
      mov    B,A
	  rjmp Alarm
Schleife:
      ldi    A,2      ;Neue Messung
      rcall  RdADC 
	  cp     A,B
	  brsh   Ende
      sub    B,A      ;Alt - Neu 
	  cpi    B,2      ;2 Stufen dunkler? 
      brsh   Alarm
Ende:
      mov    B,A      ;Alt = Neu
      rcall  Pause2
      rjmp   Schleife
Alarm:
      sbi    portb,3
      rcall  Pause2
      cbi    portb,3
      rjmp   Ende

AdcInit: 
      ldi   A,3         ;Clock / 4 
      out   ADCSRA,A	
      sbi   ADCSRA,ADEN ;AD einschalten 
      ret

RdADC:
      out   ADMUX,A
      sbi   ADMUX,ADLAR   ;Left adjust
      sbi   ADCSRA,ADSC   ;Wandlung starten
ADrdy:
      sbic  ADCSRA,ADSC   
      rjmp  ADrdy
      sbi   ADCSRA,ADSC
ADrdyb:
      sbic  ADCSRA,ADSC   
      rjmp  ADrdyb
      in    A,ADCH
      ret


Pause:
      ldi   Delay,250
P1:   nop
      dec   Delay
      brne  P1
      ret

Pause2:
      ldi   Count,250
P2:   rcall Pause
      dec   Count
      brne  P2
      ret

