#include "HT46F47E.h"

const unsigned char table[16]={
0x14, 0x4, 0x14, 0x4, 0x14, 0x4, 0x14, 0x24,
0x41, 0x40, 0x41, 0x40,0x41, 0x40, 0x41, 0x42 };

#pragma vector isr_4 @ 0x4
#pragma vector isr_8 @ 0x8
#pragma vector isr_c @ 0xc

//ISR for safequard
void isr_4(){} // external ISR
void isr_8(){} // timer/event 0
void isr_c(){} // timer/event 1

//initialize registers for safeguard
void safeguard_init(){
	_intc = 0;
	_tmrc = 0;
	_tmr = 0;
	_pac = 0xff; //input mode
	_pbc = 0xff;

}

//a long time delay
void mydelay(unsigned int times){
	while(times--)	_delay(65000);
}

void main(){
	unsigned char i, j, idx, u, pb;

	safeguard_init();

	_pac = 0; //set port A to output port
	_pa = 0; //zero port A (all light on)
	
	_pdc0 = 0;    //PC0 Ausgang
	_pd0 = 1;     //PWM einschalten
	_pwm = 100;   //PWM-Ausgabe  0...255
	
	_eadi = 0;     //Kein Interupt
	_acsr = 1;    //AD-Clock = 1/8
	
	while (1){
	
		pb = (_pb >> 1) & 7;	 

		if (pb == 7) {
			_adcr = 8;      //nur B0 als ADC0, AdC0 gewaehlt
			_start=0;
			_start=1;       //AD-Start
			_start=0;
 			while (_eocb == 1);
 			u = _adrh;     //Aufloesung 8 Bit 
			_pwm = u;      //PWM-Ausgabe
			_delay(65000);
		}
	
		if (pb == 6) {
			for(i=0; i!=255; i++){
				_pa = i;
				mydelay(50);
				}
			}
		
		if (pb == 5) {
			idx = 0;
			for(i=0; i!=2; i++) {
				_pa = table[idx];
				idx++;
				mydelay(8);
				for(j=0; j!=6; j++) {
					_pa = table[idx];
					idx++;
					mydelay(1);
				}
				_pa = table[idx];
				idx++;
				mydelay(4);
			}
		}
	}
}
