//
//  Helligkeitssensor TSL 45315 auf Watterott-Breakout Board
//  4 Lux bis 262000 Lux in 4er-Schritten
//  Beschaltung:
//  SDA an PB0
// SCL an PB2
// Energieversorgung des Boards an PB1

#include <TinyWireM.h>                  // I2C Master lib for ATTinys which use USI
#include <DigiUSB.h>

#define TSL_ADDR   0x29                 // 7 bit I2C address for TSL sensor

uint16_t  Lob = 0;
uint16_t  Hib = 0;
uint16_t  Lux = 0;

void setup() {
  pinMode(1, OUTPUT);                  // Betriebsspannung TSL
  digitalWrite (1, HIGH);
  TinyWireM.begin();                   // initialize I2C
  DigiUSB.begin();
  Init_TSL();
  DigiUSB.delay (2000);
}


void loop() {
  Get_Lux();
  DigiUSB.delay (500);
}


void Init_TSL() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x80);                                 // Control Register
  TinyWireM.send(0x03);                                 // Power on
  TinyWireM.endTransmission();
  TinyWireM.beginTransmission (TSL_ADDR);
  TinyWireM.send (0x81);                                // command register
  TinyWireM.send (0x00);                                // Multiplikator 1
  TinyWireM.endTransmission();
}


void Get_Lux() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x84);                                 // data low byte register
  TinyWireM.endTransmission();
  TinyWireM.requestFrom(TSL_ADDR, 0x02);                   // request 2 bytes from slave
  Lob = TinyWireM.receive();                            // low byte
  Hib  = TinyWireM.receive();                           // high byte
//  hier kein TinyWireM.endTransmission();

  Lux = Lob + (256 * Hib);

  if (Lux > 12500) {                                    // ab 50000 Lux wird in 100er- Schritten angezeigt
    Lux = Lux / 25 ;
    DigiUSB.print ("Helligkeit: ");
    DigiUSB.print (Lux, DEC);
    DigiUSB.println ("00 Lux");
  }
  else {
    Lux = Lux * 4;                                      // entspricht * 4
    DigiUSB.print ("Helligkeit: ");
    DigiUSB.print ( Lux, DEC);
    DigiUSB.println ( " Lux");
  }
}

