

#include <TinyWireM.h>                  // I2C Master lib for ATTinys which use USI
#include <DigiCDC.h>

#define TSL_ADDR   0x29                 // 7 bit I2C address for TSL sensor

uint16_t Lob = 0;
uint16_t Hib = 0;
uint32_t Lux = 0;

void setup() {
  pinMode(1, OUTPUT);                  // Betriebsspannung TSL
  digitalWrite (1, HIGH);
  TinyWireM.begin();                   // initialize I2C
  SerialUSB.begin();                   // initialize Serial USB
  Init_TSL();
  SerialUSB.delay (3000);
}


void loop() {
  if (SerialUSB.available()) {       // workaround, nur unter Linux erforderlich 
    Get_Lux();
    SerialUSB.delay (500);
  }
}


void Init_TSL() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x80);                                 // Control Register
  TinyWireM.send(0x03);                                 // Power on
  TinyWireM.endTransmission();
  TinyWireM.beginTransmission (TSL_ADDR);
  TinyWireM.send (0x81);                                // command register
  TinyWireM.send (0x02);                                // Multiplikator 4
  TinyWireM.endTransmission();
}


void Get_Lux() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x84);                                 // data low byte register
  TinyWireM.endTransmission();
  TinyWireM.requestFrom(TSL_ADDR, 2);                   // request 2 bytes from slave
  Lob = TinyWireM.receive();                            // low byte
  Hib  = TinyWireM.receive();                           // high byte
// hier kein  TinyWireM.endTransmission();
  Lux = Lob + (256 * Hib);
  if (Lux > 12500) {                                    // ab 50000 Lux wird in 100er- Schritten angezeigt
    Lux = Lux / 25 ;
    SerialUSB.print ("Helligkeit: ");
    SerialUSB.print (Lux, DEC);
    SerialUSB.println ("00 Lux");
  }
  else {
    Lux = Lux * 4;                                      // entspricht * 4
    SerialUSB.print ("Helligkeit: ");
    SerialUSB.print ( Lux, DEC);
    SerialUSB.println ( " Lux");
  }
}



