

#include <TinyWireM.h>                  // I2C Master lib for ATTinys which use USI
#include <DigiCDC.h>

#define TSL_ADDR   0x29                 // 7 bit I2C address for TSL sensor

int Lob = 0;
int Hib = 0;
int Lux = 0;

void setup() {
  pinMode(1, OUTPUT);                  // Betriebsspannung TSL
  digitalWrite (1, HIGH);
  TinyWireM.begin();                   // initialize I2C
  SerialUSB.begin();                   // initialize Serial USB
  Init_TSL();
  SerialUSB.delay (3000);
}


void loop() {
  if (SerialUSB.available()) {
    Get_Lux();
    SerialUSB.delay (100);
  }
}


void Init_TSL() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x80);                                 // Control Register
  TinyWireM.send(0x03);                                 // Power on
  TinyWireM.endTransmission();
  SerialUSB.delay (100);
  TinyWireM.beginTransmission (TSL_ADDR);
  TinyWireM.send (0x81);                                // command register
    TinyWireM.send (0x00);                                // Multiplikator 1
  TinyWireM.endTransmission();
}


void Get_Lux() {
  TinyWireM.beginTransmission(TSL_ADDR);
  TinyWireM.send(0x84);                                 // data low byte register
  TinyWireM.endTransmission();
  TinyWireM.requestFrom(TSL_ADDR, 2);                   // request 2 bytes from slave
  Lob = TinyWireM.receive();                            // low byte
  Hib  = TinyWireM.receive();                           // high byte
  // hier kein TinyWireM.endTransmission();
  Lux = Lob + (256 * Hib);
  SerialUSB.print ("Helligkeit: ");
  SerialUSB.print (Lux, DEC);
  SerialUSB.println (" Lux");
}



