VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "SDsound data file creator - (C) Arne Rossius 2013 - http://www.ebps.de.vu/"
   ClientHeight    =   3765
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3765
   ScaleWidth      =   7680
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fmeCenter 
      BorderStyle     =   0  'None
      Height          =   615
      Left            =   2520
      TabIndex        =   3
      Top             =   2880
      Width           =   2295
      Begin VB.CommandButton cmdUp 
         Caption         =   "up"
         Enabled         =   0   'False
         Height          =   375
         Left            =   0
         TabIndex        =   0
         Top             =   120
         Width           =   1095
      End
      Begin VB.CommandButton cmdDown 
         Caption         =   "down"
         Enabled         =   0   'False
         Height          =   375
         Left            =   1200
         TabIndex        =   1
         Top             =   120
         Width           =   1095
      End
   End
   Begin VB.Frame fmeLeft 
      BorderStyle     =   0  'None
      Height          =   615
      Left            =   120
      TabIndex        =   6
      Top             =   2880
      Width           =   2415
      Begin VB.CommandButton cmdAdd 
         Caption         =   "Add"
         Height          =   375
         Left            =   0
         TabIndex        =   8
         Top             =   120
         Width           =   1095
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "Delete"
         Enabled         =   0   'False
         Height          =   375
         Left            =   1200
         TabIndex        =   7
         Top             =   120
         Width           =   1095
      End
   End
   Begin MSComctlLib.ProgressBar prgProgress 
      Height          =   255
      Left            =   720
      TabIndex        =   4
      Top             =   60
      Visible         =   0   'False
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
      Min             =   1e-4
      Scrolling       =   1
   End
   Begin MSComctlLib.ListView lstFiles 
      Height          =   2175
      Left            =   120
      TabIndex        =   2
      Top             =   360
      Width           =   7095
      _ExtentX        =   12515
      _ExtentY        =   3836
      View            =   3
      LabelEdit       =   1
      MultiSelect     =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      OLEDropMode     =   1
      FullRowSelect   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      OLEDropMode     =   1
      NumItems        =   3
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "n"
         Object.Width           =   2646
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "File"
         Object.Width           =   2646
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   1
         SubItemIndex    =   2
         Text            =   "Size"
         Object.Width           =   2646
      EndProperty
   End
   Begin MSComDlg.CommonDialog dlg 
      Left            =   6360
      Top             =   600
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      Filter          =   "All files|*.*"
   End
   Begin VB.Frame fmeRight 
      BorderStyle     =   0  'None
      Height          =   975
      Left            =   4800
      TabIndex        =   9
      Top             =   2520
      Width           =   2535
      Begin VB.CommandButton cmdExit 
         Cancel          =   -1  'True
         Caption         =   "Exit"
         Height          =   375
         Left            =   1320
         TabIndex        =   11
         Top             =   480
         Width           =   1095
      End
      Begin VB.CommandButton cmdExport 
         Caption         =   "Export"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   10
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Total:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   60
         Width           =   735
      End
      Begin VB.Label lblTotal 
         Alignment       =   1  'Right Justify
         Caption         =   "0"
         Height          =   255
         Left            =   645
         TabIndex        =   13
         Top             =   60
         Width           =   1335
      End
   End
   Begin VB.CheckBox chkSI 
      Caption         =   "SI units"
      Height          =   255
      Left            =   6360
      TabIndex        =   14
      Top             =   60
      Width           =   975
   End
   Begin VB.Label lblProgress 
      Caption         =   "files"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   60
      Visible         =   0   'False
      Width           =   615
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private MinWidth As Long
Private MinHeight As Long
Const N_TITLES = 64

Sub add_file(fn)
  If Dir$(fn) = "" Then Exit Sub
  fs = FileLen(fn)
  If lstFiles.ListItems.Count > 0 Then
    idx = lstFiles.SelectedItem.Index
  Else
    idx = 0
  End If
  lstFiles.ListItems.Add idx + 1
  lstFiles.ListItems(idx + 1).Tag = fs
  lstFiles.ListItems(idx + 1).ListSubItems.Add 1, , fn
  lstFiles.ListItems(idx + 1).ListSubItems.Add 2
  If (idx > 0) Then lstFiles.ListItems(idx).Selected = False
  lstFiles.ListItems(idx + 1).Selected = True
End Sub

Sub list_up(idx)
  If idx = 1 Then Exit Sub
  lstFiles.ListItems.Add idx + 1
  lstFiles.ListItems.Item(idx + 1).Tag = lstFiles.ListItems(idx - 1).Tag
  lstFiles.ListItems.Item(idx + 1).ListSubItems.Add 1, , lstFiles.ListItems(idx - 1).ListSubItems(1).Text
  lstFiles.ListItems.Item(idx + 1).ListSubItems.Add 2, , lstFiles.ListItems(idx - 1).ListSubItems(2).Text
  lstFiles.ListItems.Remove idx - 1
End Sub

Sub list_down(idx)
  If idx = lstFiles.ListItems.Count Then Exit Sub
  lstFiles.ListItems.Add idx
  lstFiles.ListItems.Item(idx).Tag = lstFiles.ListItems(idx + 2).Tag
  lstFiles.ListItems.Item(idx).ListSubItems.Add 1, , lstFiles.ListItems(idx + 2).ListSubItems(1).Text
  lstFiles.ListItems.Item(idx).ListSubItems.Add 2, , lstFiles.ListItems(idx + 2).ListSubItems(2).Text
  lstFiles.ListItems.Remove idx + 2
End Sub

Function format_size(size) As String
  If chkSI.Value Then
    If size >= 2 ^ 30 Then
      format_size = Left$(CStr(size / 2 ^ 30), 4) + " GiB"
    ElseIf size >= 2 ^ 20 Then
      format_size = Left$(CStr(size / 2 ^ 20), 4) + " MiB"
    ElseIf size >= 2 ^ 10 Then
      format_size = Left$(CStr(size / 2 ^ 10), 4) + " KiB"
    Else
      format_size = CStr(size)
    End If
    format_size = Replace$(Replace$(format_size, ", ", " "), ". ", " ")
  Else
    format_size = Format$(size, "# ### ### ##0")
  End If
End Function

Sub list_update()
  total = 0
  For i = 1 To lstFiles.ListItems.Count
    lstFiles.ListItems(i).Text = i
    fs = CLng(lstFiles.ListItems(i).Tag)
    total = total + fs
    lstFiles.ListItems(i).ListSubItems(2).Text = format_size(fs)
  Next
  lblTotal.Caption = format_size(total)
  If lstFiles.ListItems.Count = 0 Then
    cmdAdd.Enabled = True
    cmdDelete.Enabled = False
    cmdUp.Enabled = False
    cmdDown.Enabled = False
    cmdExport.Enabled = False
    cmdExit.Enabled = True
  ElseIf lstFiles.ListItems.Count = N_TITLES Then
    cmdAdd.Enabled = False
    cmdDelete.Enabled = True
    cmdUp.Enabled = True
    cmdDown.Enabled = True
    cmdExport.Enabled = True
    cmdExit.Enabled = True
  Else
    cmdAdd.Enabled = True
    cmdDelete.Enabled = True
    cmdUp.Enabled = True
    cmdDown.Enabled = True
    cmdExport.Enabled = True
    cmdExit.Enabled = True
  End If
End Sub

Private Sub chkSI_Click()
  list_update
End Sub

Private Sub cmdAdd_Click()
  dlg.Flags = cdlOFNAllowMultiselect Or cdlOFNHideReadOnly Or cdlOFNFileMustExist Or cdlOFNExplorer
  'dlg.Filter = "RAW audio (*.raw)|*.raw|All file types|*.*"
  dlg.FileName = cmdAdd.Tag
  On Error GoTo add_cancel
  dlg.MaxFileSize = 32767
  dlg.ShowOpen
  On Error GoTo 0
  fn = Split(dlg.FileName, Chr$(0))
  cmdAdd.Tag = fn(0) + "\*.*"
  If UBound(fn) > 0 Then
    If UBound(fn) + lstFiles.ListItems.Count > N_TITLES Then
      MsgBox "Adding " + CStr(UBound(fn)) + " files would cause list to exceed " + CStr(N_TITLES) + " entries.", vbExclamation
      Exit Sub
    End If
    For i = 1 To UBound(fn)
      add_file fn(0) + "\" + fn(i)
    Next
  Else
    add_file fn(0)
  End If
  list_update
  lstFiles.Tag = "changed"
  Exit Sub
add_cancel:
End Sub

Private Sub cmdDelete_Click()
  idx = lstFiles.SelectedItem.Index
  For i = lstFiles.ListItems.Count To 1 Step -1
    If lstFiles.ListItems(i).Selected Then
      lstFiles.ListItems.Remove i
    End If
  Next
  If lstFiles.ListItems.Count > 0 Then
    If idx > lstFiles.ListItems.Count Then idx = lstFiles.ListItems.Count
    lstFiles.ListItems(idx).Selected = True
  End If
  list_update
  lstFiles.Tag = "changed"
End Sub

Private Sub cmdDown_Click()
  If lstFiles.ListItems(lstFiles.ListItems.Count).Selected Then Exit Sub
  For i = lstFiles.ListItems.Count To 1 Step -1
    If lstFiles.ListItems(i).Selected Then list_down i
  Next
  list_update
  lstFiles.Tag = "changed"
End Sub

Private Sub cmdExit_Click()
  If lstFiles.Tag = "changed" Then
    If MsgBox("Changes were made since last export! Really exit?", vbQuestion Or vbYesNo) = vbNo Then
      Exit Sub
    End If
  End If
  Unload Me
End Sub

Private Sub cmdExport_Click()
  Dim data As String * 512
  Dim fs(1 To N_TITLES), ss(1 To N_TITLES)
  cmdAdd.Enabled = False
  cmdDelete.Enabled = False
  cmdUp.Enabled = False
  cmdDown.Enabled = False
  cmdExport.Enabled = False
  cmdExit.Enabled = False
  dlg.Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNNoReadOnlyReturn Or cdlOFNOverwritePrompt Or cdlOFNPathMustExist
  dlg.FileName = cmdExport.Tag
  On Error GoTo export_cancel
  dlg.MaxFileSize = 32767
  dlg.ShowSave
  On Error GoTo 0
  ofn = dlg.FileName
  cmdExport.Tag = ofn
  'On Error GoTo export_fail
  Open ofn For Output Access Write As 2
  lblProgress.Visible = True
  lblProgress.Caption = "sizes"
  prgProgress.Visible = True
  prgProgress.Min = 0
  prgProgress.Max = 32767
  prgProgress.Value = 0
  DoEvents
  n = lstFiles.ListItems.Count
  S = 1
  For i = 1 To 64
    ss(i) = 0
    If (i <= n) Then
      fs(i) = FileLen(lstFiles.ListItems(i).ListSubItems(1).Text)
      ss(i) = (fs(i) + 511) \ 512
      Print #2, Chr$(S And &HFF); Chr$((S \ 256) And &HFF); Chr$((S \ 65536) And &HFF); Chr$((S \ 16777216) And &HFF);
      Print #2, Chr$(ss(i) And &HFF); Chr$((ss(i) \ 256) And &HFF); Chr$((ss(i) \ 65536) And &HFF); Chr$((ss(i) \ 16777216) And &HFF);
      S = S + ss(i)
    Else
      Print #2, String$(16, 0);
    End If
  Next
  S = 0
  For i = 1 To n
    lblProgress.Caption = CStr(i) + "/" + CStr(n)
    prgProgress.Value = 0
    DoEvents
    ifn = lstFiles.ListItems(i).ListSubItems(1).Text
    Open ifn For Binary Access Read As 1
    For j = 1 To ss(i) - 1
      Get 1, , data
      'Put 2, , data
      Print #2, data;
      S = S + 1
      If (j And 1023) = 0 Then
        prgProgress.Value = 32767 / ss(i) * j
        DoEvents
      End If
    Next
    e = ss(i) * 512 - fs(i)
    Get 1, , data
    If (e > 0) Then
      Mid$(data, 513 - e, e) = String(e, &H80)
    End If
    Print #2, data
    S = S + 1
    Close 1
  Next
  Close 2
  lstFiles.Tag = ""
  MsgBox "Export complete, " + CStr(S) + " sectors written.", vbInformation
  GoTo export_end
export_fail:
  MsgBox "File export failed with error:" + vbCrLf + Err.Description + vbCrLf + vbCrLf + "Export aborted.", vbCritical
  Close
export_cancel:
export_end:
  lblProgress.Visible = False
  prgProgress.Visible = False
  list_update
End Sub

Private Sub cmdUp_Click()
  If lstFiles.ListItems(1).Selected Then Exit Sub
  For i = 1 To lstFiles.ListItems.Count
    If lstFiles.ListItems(i).Selected Then list_up i
  Next
  list_update
  lstFiles.Tag = "changed"
End Sub

Private Sub Form_Load()
  lstFiles.ColumnHeaders(1).Width = 30 * Screen.TwipsPerPixelX
  lstFiles.ColumnHeaders(3).Width = 90 * Screen.TwipsPerPixelX
'  MinWidth = Me.Width
  MinWidth = fmeRight.Left + fmeRight.Width + Me.Width - Me.ScaleWidth
  MinHeight = Me.Height
  Me.Width = Screen.Width * 2 / 3
  Me.Height = Screen.Height * 2 / 3
  Form_Resize
End Sub

Private Sub Form_Resize()
  On Error Resume Next
  If (Me.WindowState = vbNormal) Then
    If Me.Width < MinWidth Then Me.Width = MinWidth
    If Me.Height < MinHeight Then Me.Height = MinHeight
  End If
  
  fmeCenter.Left = (Me.ScaleWidth - fmeCenter.Width) \ 2
  fmeRight.Left = Me.ScaleWidth - fmeRight.Width
  chkSI.Left = Me.ScaleWidth - chkSI.Width
  
  fmeLeft.Top = Me.ScaleHeight - fmeLeft.Height
  fmeCenter.Top = Me.ScaleHeight - fmeCenter.Height
  fmeRight.Top = Me.ScaleHeight - fmeRight.Height
  
  lstFiles.Width = Me.ScaleWidth - 2 * lstFiles.Left
  lstFiles.ColumnHeaders(2).Width = lstFiles.Width - (30 + 90 + 6 + 20) * Screen.TwipsPerPixelX
  prgProgress.Width = lstFiles.Width - lblProgress.Width
  
  lstFiles.Height = Me.ScaleHeight - lstFiles.Top - fmeRight.Height
  
End Sub

Private Sub lstFiles_OLEDragDrop(data As MSComctlLib.DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
  If data.GetFormat(vbCFFiles) Then
    If data.Files.Count + lstFiles.ListItems.Count > N_TITLES Then
      MsgBox "Adding " + CStr(data.Files.Count) + " files would cause list to exceed " + CStr(N_TITLES) + " entries.", vbExclamation
      Exit Sub
    End If
    For i = 1 To data.Files.Count
      add_file data.Files(i)
    Next
    list_update
    lstFiles.Tag = "changed"
  End If
End Sub

Private Sub ProgressBar1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)

End Sub
