;*******************************************************************
; Author = Jesper Hansen (C) GNU General Public License
; adaptiert fr  32 bit Phasenaccumulator und debugged von
; Rudolf Drabek Nov. 2010. Fr den Code keinerlei Garantie, nur fr	
; Privatverwendung und Ausbildungszwecke zu verwenden
;*******************************************************************
; PB0..7 =  DA Wandler Data out
; PD0	 =	RXD
;*******************************************************************
;* Fuse setting auf 0 (gesetzt):
;* Ext. Byte:	Selfpgren enabled
;* Hi Byte:		Default
;* Low Byte:	"FF" = Clock undivided, startup long, >8MHz Quarz
;********************************************************************
; Output frequency (using 32 bit accumulator) :
;
;	f = deltaPhase * fClock/2^32
;
;   fClock is in this case the CPU clock divided by the
;	number of cycles to output the data ( 11 cycles )
;
;	f = r24/r25/r26 * (16000000/11)*10/65536*65536
;	f = r23/r24/r25/r26*0,000338662754
;
;	fMax (theoretical) = 0.5 * fClock  = 727272 Hz = 0,687500 us DDS-Takt
;	1 Durchlauf bei 1er Step bentigt also 2952,790016 Sekunden
;	Wichtig fr die Genauigkeit sind die 2 Nullen weiter hinter dem Komma.  
;	Fehler bei 	0.1 Hz		900 ppm
;				1	HZ		 71 ppm
;				10	HZ		  3 ppm
;   im NF-Bereich ist der Fehler bestimmt durch die Genauigkeit des Quarzes.
;******************************************************************************
;incrementwerte je Frequenzstep. Viel herumprobieren hilft fr die Genauigkeit
;	0.1 Hz		295				0x0127 .
;	  1 		2953			0x0b89
;	 10			29528			0x7358
;	100			295279			0x04816f
;  1000         2952790			0x2d0e56
; 10000			29527900  		0x01c28f5c
;	  	 statt  29527900,16. Fehler s.o. 0,005 ppm ab 100 Hz
;******************************************************************************

.include "tn2313def.inc"
	.org 0
		rjmp	reset
	.org 7					;RX complete interrupt
		rjmp	rx5

;******************************************************************************
; data tables
;******************************************************************************
;.cseg
; force table to begin at 256 byte boundary

	.org 0x80		;word address

sine:		; 256 step sinewave table
.db	0x80,0x83,0x86,0x89,0x8c,0x8f,0x92,0x95,0x98,0x9c,0x9f,0xa2,0xa5,0xa8,0xab,0xae
.db	0xb0,0xb3,0xb6,0xb9,0xbc,0xbf,0xc1,0xc4,0xc7,0xc9,0xcc,0xce,0xd1,0xd3,0xd5,0xd8
.db	0xda,0xdc,0xde,0xe0,0xe2,0xe4,0xe6,0xe8,0xea,0xec,0xed,0xef,0xf0,0xf2,0xf3,0xf5
.db	0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfc,0xfd,0xfe,0xfe,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xfe,0xfd,0xfc,0xfc,0xfb,0xfa,0xf9,0xf8,0xf7
.db	0xf6,0xf5,0xf3,0xf2,0xf0,0xef,0xed,0xec,0xea,0xe8,0xe6,0xe4,0xe2,0xe0,0xde,0xdc
.db	0xda,0xd8,0xd5,0xd3,0xd1,0xce,0xcc,0xc9,0xc7,0xc4,0xc1,0xbf,0xbc,0xb9,0xb6,0xb3
.db	0xb0,0xae,0xab,0xa8,0xa5,0xa2,0x9f,0x9c,0x98,0x95,0x92,0x8f,0x8c,0x89,0x86,0x83
.db	0x80,0x7c,0x79,0x76,0x73,0x70,0x6d,0x6a,0x67,0x63,0x60,0x5d,0x5a,0x57,0x54,0x51
.db	0x4f,0x4c,0x49,0x46,0x43,0x40,0x3e,0x3b,0x38,0x36,0x33,0x31,0x2e,0x2c,0x2a,0x27
.db	0x25,0x23,0x21,0x1f,0x1d,0x1b,0x19,0x17,0x15,0x13,0x12,0x10,0x0f,0x0d,0x0c,0x0a
.db	0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x03,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x02,0x03,0x03,0x04,0x05,0x06,0x07,0x08
.db	0x09,0x0a,0x0c,0x0d,0x0f,0x10,0x12,0x13,0x15,0x17,0x19,0x1b,0x1d,0x1f,0x21,0x23
.db	0x25,0x27,0x2a,0x2c,0x2e,0x31,0x33,0x36,0x38,0x3b,0x3e,0x40,0x43,0x46,0x49,0x4c
.db	0x4f,0x51,0x54,0x57,0x5a,0x5d,0x60,0x63,0x67,0x6a,0x6d,0x70,0x73,0x76,0x79,0x7c

triangle:	; 256 step trianglewave table
.db	0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,0x10,0x12,0x14,0x16,0x18,0x1a,0x1c,0x1e
.db	0x20,0x22,0x24,0x26,0x28,0x2a,0x2c,0x2e,0x30,0x32,0x34,0x36,0x38,0x3a,0x3c,0x3e
.db	0x40,0x42,0x44,0x46,0x48,0x4a,0x4c,0x4e,0x50,0x52,0x54,0x56,0x58,0x5a,0x5c,0x5e
.db	0x60,0x62,0x64,0x66,0x68,0x6a,0x6c,0x6e,0x70,0x72,0x74,0x76,0x78,0x7a,0x7c,0x7e
.db	0x80,0x82,0x84,0x86,0x88,0x8a,0x8c,0x8e,0x90,0x92,0x94,0x96,0x98,0x9a,0x9c,0x9e
.db	0xa0,0xa2,0xa4,0xa6,0xa8,0xaa,0xac,0xae,0xb0,0xb2,0xb4,0xb6,0xb8,0xba,0xbc,0xbe
.db	0xc0,0xc2,0xc4,0xc6,0xc8,0xca,0xcc,0xce,0xd0,0xd2,0xd4,0xd6,0xd8,0xda,0xdc,0xde
.db	0xe0,0xe2,0xe4,0xe6,0xe8,0xea,0xec,0xee,0xf0,0xf2,0xf4,0xf6,0xf8,0xfa,0xfc,0xfe
.db	0xff,0xfd,0xfb,0xf9,0xf7,0xf5,0xf3,0xf1,0xef,0xef,0xeb,0xe9,0xe7,0xe5,0xe3,0xe1
.db	0xdf,0xdd,0xdb,0xd9,0xd7,0xd5,0xd3,0xd1,0xcf,0xcf,0xcb,0xc9,0xc7,0xc5,0xc3,0xc1
.db	0xbf,0xbd,0xbb,0xb9,0xb7,0xb5,0xb3,0xb1,0xaf,0xaf,0xab,0xa9,0xa7,0xa5,0xa3,0xa1
.db	0x9f,0x9d,0x9b,0x99,0x97,0x95,0x93,0x91,0x8f,0x8f,0x8b,0x89,0x87,0x85,0x83,0x81
.db	0x7f,0x7d,0x7b,0x79,0x77,0x75,0x73,0x71,0x6f,0x6f,0x6b,0x69,0x67,0x65,0x63,0x61
.db	0x5f,0x5d,0x5b,0x59,0x57,0x55,0x53,0x51,0x4f,0x4f,0x4b,0x49,0x47,0x45,0x43,0x41
.db	0x3f,0x3d,0x3b,0x39,0x37,0x35,0x33,0x31,0x2f,0x2f,0x2b,0x29,0x27,0x25,0x23,0x21
.db	0x1f,0x1d,0x1b,0x19,0x17,0x15,0x13,0x11,0x0f,0x0f,0x0b,0x09,0x07,0x05,0x03,0x01

sawtooth:	; 256 step sawtoothwave table
.db	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f
.db	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f
.db	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f
.db	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f
.db	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f
.db	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f
.db	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f
.db	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f
.db	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f
.db	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f
.db	0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf
.db	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf
.db	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf
.db	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf
.db	0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef
.db	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff


square:		; 256 step squarewave table
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
.db	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff


reset:
		ldi		r16, RAMEND
		out		SPL, r16		; setup stack pointer
		ldi		r16,0x01		; set UART speed to 500 kbps
		out		UBRRL,r16
;		ldi		r16,2			;nur bei Control_uC da er 8 MHz clock hat
;		out		UCSRA,r16		;double speed = bit1 Seite 134
 		ldi		r16,6			;Frame format 8N1, Seite137
		out     UCSRC,r16		;an sich der Defaultwert
		ldi		r16,0x90		; enable RXint and enable RXEN Seite 135
		out		UCSRB,r16		; UCSRC default Seite 136

		sei						; global enable interrupts
		ser		r16				; 
		out		DDRB,r16		; set all PORTB bits as output
	
	; set sinewave output as default
		ldi		r31,high(sine*2)	; setup Z pointer hi
		ldi		r30,low(sine*2)	; setup Z pointer lo

	; clear accumulator 
		ldi 	r27,0x00		; clear accumulator 
		ldi 	r28,0x00		; clear accumulator 
		ldi 	r29,0x00		; clear accumulator 
		;ldi 	r30,0x00		; schon gesetzt mit Sinustabellenadresse

	; setup adder registers	;max.Wert 12000000h = 301989888d = 102272,7Hz
		ldi 	r22,byte1(295279*4+29528*4)	; setup adder value
		ldi 	r23,byte2(295279*4+29528*4)	; to 440 Hz
		ldi 	r24,byte3(295279*4+29528*4)
		ldi 	r25,byte4(295279*4+29528*4)
				; 
; main loop
;	r27,r28,r29,r30 is the phase accumulator
;  	r22,r23,r24,r25 is the adder value determining the frequency
;
; 	add value to accumulator
;	load byte from current table in ROM
;	output byte to port
;	repeat 
;
main:	add		r27,r22			; 1
		add		r28,r23			; 1
		adc		r29,r24			; 1
		adc		r30,r25			; 1
		nop						; 1	;das "nop" gibt hhere Genauigkeit s.o.
		lpm						; 3	;reduziert aber die max. Frequenz
		out		PortB,r0		; 1	;von 800 auf 727 kHz
		rjmp	main			; 2 ;ich begrenze sowieso auf 102 kHz 
						;in Summe 11 cycles

;**********************************************************************
; communication functionality mit 500 kBaud = 2us je bit
; ich bertrage 5 Bytes = 50 bits  dauert 100 us
; gibt minimale Unterbrechung bei Frequenzumschaltung
; bei tiefen Frequenzen ist kein Umschaltgerusch hrbar!
;**********************************************************************

; Nach dem 1. Byte werden die 4 restl. via polling geholt
; Damit ist besser sichergestellt, dass sich die Phase nicht verhaspelt

; ev. Kontrolle mit LED einbauen ob 5 Byte empfangen wurden
; war bisher nicht ntig. Wenn dann mit Hammerschlag = watchdog lsen.


	
rx5:	cli					
		in 		r17,UDR		;das 1. Byte ist die Spannungsform
		rcall	get_char
		mov		r22,r16		;der Phasenaccu Adderwert 32 bit
		rcall	get_char
		mov		r23,r16
		rcall	get_char
		mov		r24,r16
		rcall	get_char
		mov		r25,r16
		cpi		r17,5
		BRLO	joke
		ldi		r17,1		;default SINUS
joke:	mov		r31,r17		;das high Byte der Tabellen
		sei
		reti

get_char:						;7  	;incl. ret		
		sbis	ucsra,rxc		;1/2 	;ready ?
		rjmp	get_char		;2 		;no, wait some more
		in		r16,UDR			;1 		;get the byte
		ret				;min	10 cycles +3 je ev. waitcycle 

;******************************************************************************
; end of file	
;******************************************************************************


